/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers;

import java.io.IOException;
import java.util.logging.Logger;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.ConnectionType;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.FailureEventException;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.AbstractStateController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ConnectedController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.PausableController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.PauseHelper;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.PauseHelperImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.StateController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.TimeoutableController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ConnectedEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ConnectionTimedOutEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.StateInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.StreamInfo;

public abstract class TransferController
extends AbstractStateController
implements PausableController,
TimeoutableController,
ConnectedController {
    private static final Logger LOGGER = Logger.getLogger(TransferController.class.getName());
    private volatile boolean cancelled = false;
    private boolean connected = false;
    private Thread transferThread;
    private boolean suppressErrors = false;
    private RvConnection transfer;
    private final PauseHelper pauseHelper = new PauseHelperImpl();
    private StreamInfo stream;

    protected synchronized void pauseTimeout() {
        LOGGER.info("File transfer timeout paused");
        this.transfer.getTimeoutHandler().pauseTimeout(this);
    }

    protected synchronized void resumeTimeout() {
        LOGGER.info("File transfer timeout resumed");
        this.transfer.getTimeoutHandler().unpauseTimeout(this);
    }

    public ConnectionType getTimeoutType() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelIfNotFruitful(long timeout) {
        boolean timedout = false;
        TransferController transferController = this;
        synchronized (transferController) {
            if (!this.isConnected()) {
                this.cancelled = true;
                this.suppressErrors = true;
                timedout = true;
            }
        }
        if (timedout) {
            this.transferThread.interrupt();
            this.fireFailed(new ConnectionTimedOutEvent(timeout));
        }
    }

    protected synchronized boolean shouldSuppressErrors() {
        return this.suppressErrors;
    }

    public void start(final RvConnection transfer, StateController last) {
        this.transfer = transfer;
        StateInfo lastinfo = last.getEndStateInfo();
        assert (lastinfo instanceof StreamInfo) : last;
        this.stream = (StreamInfo)((Object)lastinfo);
        this.transferThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block5: {
                    try {
                        TransferController transferController = TransferController.this;
                        synchronized (transferController) {
                            transfer.getTimeoutHandler().startTimeout(TransferController.this);
                        }
                        TransferController.this.transferInThread(transfer);
                    }
                    catch (Exception e) {
                        if (TransferController.this.shouldSuppressErrors()) break block5;
                        TransferController.this.fireFailed(e);
                    }
                }
            }
        }, "File transfer thread");
        this.transferThread.start();
    }

    protected long getTransferTimeoutMillis() {
        return this.transfer.getSettings().getDefaultPerConnectionTimeout(this.transfer.getRvSessionInfo().getInitiator());
    }

    public void stop() {
        LOGGER.info("Stopping transfer controller");
        this.cancelled = true;
        this.transferThread.interrupt();
    }

    protected boolean shouldStop() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnected() {
        TransferController transferController = this;
        synchronized (transferController) {
            if (this.connected) {
                return;
            }
            this.connected = true;
        }
        LOGGER.info("File transfer is now connected");
        this.transfer.getEventPost().fireEvent(new ConnectedEvent());
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public boolean didConnect() {
        return this.isConnected();
    }

    protected abstract void transferInThread(RvConnection var1) throws IOException, FailureEventException;

    public void pauseTransfer() {
        this.pauseHelper.setPaused(true);
    }

    public void unpauseTransfer() {
        this.pauseHelper.setPaused(false);
    }

    protected boolean waitUntilUnpause() {
        return this.pauseHelper.waitUntilUnpause();
    }

    public StreamInfo getStream() {
        return this.stream;
    }
}

