/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.incoming;

import net.sf.jml.Email;
import net.sf.jml.MsnContactList;
import net.sf.jml.MsnMessageChain;
import net.sf.jml.MsnMessageIterator;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnProtocol;
import net.sf.jml.MsnUser;
import net.sf.jml.MsnUserPropertyType;
import net.sf.jml.impl.MsnUserPropertiesImpl;
import net.sf.jml.protocol.MsnIncomingMessage;
import net.sf.jml.protocol.MsnMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.incoming.IncomingADC;
import net.sf.jml.protocol.incoming.IncomingADD;
import net.sf.jml.protocol.incoming.IncomingLST;
import net.sf.jml.util.StringUtils;

public class IncomingBPR
extends MsnIncomingMessage {
    public IncomingBPR(MsnProtocol msnProtocol) {
        super(msnProtocol);
    }

    protected boolean isSupportTransactionId() {
        return false;
    }

    public MsnUserPropertyType getPropType() {
        return MsnUserPropertyType.parseStr(this.getParam(0));
    }

    public String getProperty() {
        return StringUtils.urlDecode(this.getParam(1));
    }

    protected void messageReceived(MsnSession msnSession) {
        super.messageReceived(msnSession);
        MsnMessenger msnMessenger = msnSession.getMessenger();
        MsnContactList msnContactList = msnMessenger.getContactList();
        MsnMessageChain msnMessageChain = msnMessenger.getIncomingMessageChain();
        MsnUser msnUser = null;
        MsnMessageIterator msnMessageIterator = msnMessageChain.iterator();
        while (msnMessageIterator.hasPrevious()) {
            MsnMessage msnMessage = msnMessageIterator.previous();
            if (msnMessage instanceof IncomingBPR) continue;
            if (msnMessage instanceof IncomingLST) {
                Email email = ((IncomingLST)msnMessage).getEmail();
                msnUser = msnContactList.getContactByEmail(email);
                break;
            }
            if (msnMessage instanceof IncomingADC) {
                Email email = ((IncomingADC)msnMessage).getEmail();
                if (email == null) {
                    msnUser = msnContactList.getContactById(((IncomingADC)msnMessage).getId());
                    break;
                }
                msnUser = msnContactList.getContactByEmail(email);
                break;
            }
            if (!(msnMessage instanceof IncomingADD)) break;
            Email email = ((IncomingADD)msnMessage).getEmail();
            msnUser = msnContactList.getContactByEmail(email);
            break;
        }
        if (msnUser != null) {
            ((MsnUserPropertiesImpl)msnUser.getProperties()).setProperty(this.getPropType(), this.getProperty());
        }
    }
}

