/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.directim;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.rvcmd.AbstractRequestRvCmd;
import net.kano.joscar.rvcmd.ConnectionRequestRvCmd;
import net.kano.joscar.rvcmd.RvConnectionInfo;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.TlvChain;

public class DirectIMReqRvCmd
extends AbstractRequestRvCmd
implements ConnectionRequestRvCmd {
    private final RvConnectionInfo connInfo;

    public DirectIMReqRvCmd(RecvRvIcbm icbm) {
        super(icbm);
        TlvChain chain = this.getRvTlvs();
        this.connInfo = RvConnectionInfo.readConnectionInfo(chain);
    }

    public DirectIMReqRvCmd(RvConnectionInfo connInfo) {
        this(1, connInfo);
    }

    public DirectIMReqRvCmd(int requestIndex, RvConnectionInfo connInfo) {
        super(CapabilityBlock.BLOCK_DIRECTIM, requestIndex);
        this.connInfo = connInfo;
    }

    public final RvConnectionInfo getConnInfo() {
        return this.connInfo;
    }

    protected void writeRvTlvs(OutputStream out) throws IOException {
        if (this.connInfo != null) {
            this.connInfo.write(out);
        }
    }

    protected boolean hasServiceData() {
        return false;
    }

    protected void writeServiceData(OutputStream out) throws IOException {
    }

    public String toString() {
        return "DirectIMReqRvCmd: " + this.connInfo;
    }
}

