/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfColor;
import com.lowagie.text.rtf.style.RtfFont;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfChunk
extends RtfElement {
    private static final byte[] FONT_SUBSCRIPT = "\\sub".getBytes();
    private static final byte[] FONT_SUPERSCRIPT = "\\super".getBytes();
    private static final byte[] FONT_END_SUPER_SUBSCRIPT = "\\nosupersub".getBytes();
    private static final byte[] HIGHLIGHT = "\\highlight".getBytes();
    private RtfFont font = null;
    private String content = "";
    private boolean softLineBreaks = false;
    private float superSubScript = 0.0f;
    private RtfColor background = null;

    public RtfChunk(RtfDocument doc, Chunk chunk) {
        super(doc);
        if (chunk == null) {
            return;
        }
        if (chunk.getAttributes() != null && chunk.getAttributes().get("SUBSUPSCRIPT") != null) {
            this.superSubScript = ((Float)chunk.getAttributes().get("SUBSUPSCRIPT")).floatValue();
        }
        if (chunk.getAttributes() != null && chunk.getAttributes().get("BACKGROUND") != null) {
            this.background = new RtfColor(this.document, (Color)((Object[])chunk.getAttributes().get("BACKGROUND"))[0]);
        }
        this.font = new RtfFont(doc, chunk.font());
        this.content = chunk.content();
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (this.background != null) {
                result.write(OPEN_GROUP);
            }
            result.write(this.font.writeBegin());
            if (this.superSubScript < 0.0f) {
                result.write(FONT_SUBSCRIPT);
            } else if (this.superSubScript > 0.0f) {
                result.write(FONT_SUPERSCRIPT);
            }
            if (this.background != null) {
                result.write(HIGHLIGHT);
                result.write(this.intToByteArray(this.background.getColorNumber()));
            }
            result.write(DELIMITER);
            result.write(this.document.filterSpecialChar(this.content, false, this.softLineBreaks || this.document.getDocumentSettings().isAlwaysGenerateSoftLinebreaks()).getBytes());
            if (this.superSubScript != 0.0f) {
                result.write(FONT_END_SUPER_SUBSCRIPT);
            }
            result.write(this.font.writeEnd());
            if (this.background != null) {
                result.write(CLOSE_GROUP);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public void setRtfDocument(RtfDocument doc) {
        super.setRtfDocument(doc);
        this.font.setRtfDocument(this.document);
    }

    public void setSoftLineBreaks(boolean softLineBreaks) {
        this.softLineBreaks = softLineBreaks;
    }

    public boolean getSoftLineBreaks() {
        return this.softLineBreaks;
    }
}

