/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.util;

import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Player;
import javax.media.Processor;
import javax.media.StopEvent;
import javax.media.Time;
import javax.media.TransitionEvent;

public class StateWaiter
implements ControllerListener {
    private int state;
    private boolean stateReached = false;
    private boolean listening = false;
    private Controller controller;

    public StateWaiter(Controller controller) {
        this.controller = controller;
    }

    private void addAsListener() {
        if (!this.listening) {
            this.controller.addControllerListener(this);
            this.listening = true;
        }
    }

    public boolean blockingConfigure() {
        this.setState(180);
        ((Processor)this.controller).configure();
        return this.waitForState();
    }

    public boolean blockingPrefetch() {
        this.setState(500);
        this.controller.prefetch();
        return this.waitForState();
    }

    public boolean blockingRealize() {
        this.setState(300);
        this.controller.realize();
        return this.waitForState();
    }

    public boolean blockingStart() {
        this.setState(600);
        Player player = (Player)this.controller;
        player.start();
        return this.waitForState();
    }

    public boolean blockingSyncStart(Time time) {
        this.setState(600);
        this.controller.syncStart(time);
        return this.waitForState();
    }

    public boolean blockingWait(int n) {
        this.setState(n);
        return this.waitForState();
    }

    public synchronized void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent.getSourceController() != this.controller) {
            return;
        }
        if (controllerEvent instanceof TransitionEvent) {
            int n = ((TransitionEvent)controllerEvent).getCurrentState();
            boolean bl = this.stateReached = n >= this.state;
        }
        if (controllerEvent instanceof StopEvent || controllerEvent instanceof ControllerClosedEvent || this.stateReached) {
            this.removeAsListener();
            this.notifyAll();
        }
    }

    private void removeAsListener() {
        this.controller.removeControllerListener(this);
        this.listening = false;
    }

    private void setState(int n) {
        this.state = n;
        this.stateReached = false;
        this.addAsListener();
    }

    private synchronized boolean waitForState() {
        while (this.listening) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.stateReached;
    }
}

