/*
 * Decompiled with CFR 0.152.
 */
package com.t4l.jmf;

import com.t4l.jmf.CustomByteArrayOutputStream;
import com.t4l.jmf.RGBConverter;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.JPEGFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.utility.LoggerSingleton;

public class JPEGEncoder
implements Codec {
    private static final Logger logger = LoggerSingleton.logger;
    private static final VideoFormat jpegFormat = new JPEGFormat();
    private static final RGBFormat rgbFormat = new RGBFormat(null, -1, Format.intArray, -1.0f, -1, -1, -1, -1);
    static Hashtable imageTable = new Hashtable();

    protected static int writeJPEG(BufferedImage bufferedImage, byte[] byArray) throws IOException {
        ImageWriter imageWriter = ImageIO.getImageWritersByMIMEType("image/jpeg").next();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        float f = 0.8f;
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionQuality(f);
        CustomByteArrayOutputStream customByteArrayOutputStream = new CustomByteArrayOutputStream(byArray);
        imageWriter.setOutput(customByteArrayOutputStream);
        IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
        imageWriter.write(null, iIOImage, imageWriteParam);
        return customByteArrayOutputStream.getBytesWritten();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Hashtable hashtable = imageTable;
        synchronized (hashtable) {
            imageTable.clear();
        }
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return new String[0];
    }

    public String getName() {
        return "JPEG Encoder";
    }

    public Format[] getSupportedInputFormats() {
        return new VideoFormat[]{rgbFormat};
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return new VideoFormat[]{jpegFormat};
        }
        if (format.relax().matches(rgbFormat)) {
            VideoFormat videoFormat = (VideoFormat)format;
            return new VideoFormat[]{new JPEGFormat(videoFormat.getSize(), -1, Format.byteArray, videoFormat.getFrameRate(), -1, -1)};
        }
        return new Format[0];
    }

    public void open() throws ResourceUnavailableException {
    }

    public int process(Buffer buffer, Buffer buffer2) {
        Format format = buffer.getFormat();
        Format format2 = buffer2.getFormat();
        if (format.relax().matches(rgbFormat) && format2.relax().matches(jpegFormat)) {
            return this.processRGBtoJPEG(buffer, buffer2);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int processRGBtoJPEG(Buffer buffer, Buffer buffer2) {
        Hashtable hashtable = imageTable;
        synchronized (hashtable) {
            try {
                byte[] byArray;
                RGBFormat rGBFormat = (RGBFormat)buffer.getFormat();
                VideoFormat videoFormat = (VideoFormat)buffer2.getFormat();
                if (videoFormat == null) {
                    int n = rGBFormat.getSize().width;
                    int n2 = rGBFormat.getSize().height;
                    videoFormat = new JPEGFormat(new Dimension(n, n2), n * n2 + 200, Format.byteArray, rGBFormat.getFrameRate(), -1, -1);
                    buffer2.setFormat(videoFormat);
                }
                int[] nArray = (int[])buffer.getData();
                Dimension dimension = rGBFormat.getSize();
                BufferedImage bufferedImage = (BufferedImage)imageTable.get(dimension);
                if (bufferedImage == null) {
                    bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
                }
                RGBConverter.populateImage(nArray, buffer.getOffset(), bufferedImage, rGBFormat);
                Object object = buffer2.getData();
                if (object instanceof byte[]) {
                    byArray = (byte[])object;
                } else {
                    byArray = new byte[dimension.width * dimension.height + 200];
                    buffer2.setData(byArray);
                }
                int n = JPEGEncoder.writeJPEG(bufferedImage, byArray);
                imageTable.put(dimension, bufferedImage);
                buffer2.setLength(n);
                buffer2.setDiscard(buffer.isDiscard());
                buffer2.setDuration(buffer.getDuration());
                buffer2.setEOM(buffer.isEOM());
                buffer2.setFlags(buffer.getFlags());
                buffer2.setHeader(null);
                buffer2.setTimeStamp(buffer.getTimeStamp());
                buffer2.setSequenceNumber(buffer.getSequenceNumber());
                buffer2.setOffset(0);
                return 0;
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "" + throwable, throwable);
                return 1;
            }
        }
    }

    public void reset() {
    }

    public Format setInputFormat(Format format) {
        if (format.relax().matches(rgbFormat)) {
            return format;
        }
        return null;
    }

    public Format setOutputFormat(Format format) {
        if (format.relax().matches(jpegFormat)) {
            return format;
        }
        return null;
    }
}

