/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rtcp;

import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPFBPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPREMBPacket;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.Transformer;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.rtcp.AbstractBridgeRTCPTerminationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class REMBNotifier
implements Transformer<RTCPCompoundPacket> {
    private AbstractBridgeRTCPTerminationStrategy strategy;

    public REMBNotifier(AbstractBridgeRTCPTerminationStrategy strategy) {
        this.strategy = strategy;
    }

    public RTCPCompoundPacket reverseTransform(RTCPCompoundPacket inPacket) {
        for (RTCPPacket p : inPacket.packets) {
            Channel channel;
            if (p == null || p.type != 206) continue;
            RTCPFBPacket psfb = (RTCPFBPacket)p;
            if (psfb.fmt != 15) continue;
            RTCPREMBPacket remb = (RTCPREMBPacket)psfb;
            Conference conference = this.strategy.getConference();
            if (conference == null || (channel = conference.findChannelByReceiveSSRC(remb.senderSSRC, MediaType.VIDEO)) == null || !(channel instanceof VideoChannel)) continue;
            ((VideoChannel)channel).receivedREMB(remb.getBitrate());
        }
        return inPacket;
    }

    public void close() {
    }

    public RTCPCompoundPacket transform(RTCPCompoundPacket inPacket) {
        return inPacket;
    }
}

