/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.pubsub;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.java.sip.communicator.util.Logger;
import org.jitsi.videobridge.pubsub.PubSubResponseListener;
import org.jitsi.videobridge.stats.StatsManagerBundleActivator;
import org.jitsi.videobridge.xmpp.ComponentImpl;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.pubsub.AccessModel;
import org.jivesoftware.smackx.pubsub.ConfigureForm;
import org.jivesoftware.smackx.pubsub.FormNode;
import org.jivesoftware.smackx.pubsub.FormNodeType;
import org.jivesoftware.smackx.pubsub.FormType;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.PublishItem;
import org.jivesoftware.smackx.pubsub.PublishModel;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.osgi.framework.BundleContext;

public class PubSubPublisher {
    private static final Map<String, PubSubPublisher> instances = new HashMap<String, PubSubPublisher>();
    private static final Logger logger = Logger.getLogger(PubSubPublisher.class);
    private static final int PACKET_TIMEOUT = 500;
    private List<PubSubResponseListener> listeners = new LinkedList<PubSubResponseListener>();
    private List<String> nodes = new LinkedList<String>();
    private Map<String, String> pendingConfigureRequests = new HashMap<String, String>();
    private Map<String, String> pendingCreateRequests = new HashMap<String, String>();
    private Map<String, String> pendingPublishRequests = new HashMap<String, String>();
    private String serviceName;
    private Timer timeoutTimer = new Timer();

    public static PubSubPublisher getPubsubManager(String serviceName) {
        PubSubPublisher publisher;
        if (instances.containsKey(serviceName)) {
            publisher = instances.get(serviceName);
        } else {
            publisher = new PubSubPublisher(serviceName);
            instances.put(serviceName, publisher);
        }
        return publisher;
    }

    public static void handleIQResponse(IQ response) {
        PubSubPublisher publisher;
        IQ.Type type = response.getType();
        if (IQ.Type.ERROR.equals(type)) {
            PubSubPublisher publisher2 = instances.get(response.getFrom());
            if (publisher2 != null) {
                publisher2.handleErrorResponse(response);
            }
        } else if (IQ.Type.RESULT.equals(type) && (publisher = instances.get(response.getFrom())) != null) {
            publisher.handleCreateNodeResponse(response);
            publisher.handleConfigureResponse(response);
            publisher.handlePublishResponse(response);
        }
    }

    public static void releasePubsubManager(PubSubPublisher publisher) {
        instances.values().remove(publisher);
        publisher.dispose();
    }

    private PubSubPublisher(String serviceName) {
        this.serviceName = serviceName;
    }

    public void addResponseListener(PubSubResponseListener l) {
        if (l == null) {
            throw new NullPointerException("l");
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    private void configureNode(String nodeName) {
        ConfigureForm cfg = new ConfigureForm(FormType.submit);
        PubSub pubsub = new PubSub();
        cfg.setAccessModel(AccessModel.open);
        cfg.setPersistentItems(false);
        cfg.setPublishModel(PublishModel.open);
        pubsub.setTo(this.serviceName);
        pubsub.setType(IQ.Type.SET);
        final String packetID = IQ.nextID();
        pubsub.setPacketID(packetID);
        pubsub.addExtension((PacketExtension)new FormNode(FormNodeType.CONFIGURE_OWNER, (Form)cfg));
        try {
            this.send((IQ)pubsub);
        }
        catch (Exception e) {
            logger.error((Object)"Error sending configuration form.");
            this.fireResponseCreateEvent(PubSubResponseListener.Response.SUCCESS);
            return;
        }
        this.pendingConfigureRequests.put(packetID, nodeName);
        this.timeoutTimer.schedule(new TimerTask(){

            public void run() {
                String nodeName = (String)PubSubPublisher.this.pendingConfigureRequests.remove(packetID);
                if (nodeName != null) {
                    logger.error((Object)("Configuration of the node failed: " + nodeName));
                    PubSubPublisher.this.fireResponseCreateEvent(PubSubResponseListener.Response.SUCCESS);
                }
            }
        }, 500L);
    }

    public void createNode(String nodeName) throws Exception {
        PubSub request = new PubSub();
        request.setTo(this.serviceName);
        request.setType(IQ.Type.SET);
        final String packetID = Packet.nextID();
        request.setPacketID(packetID);
        request.addExtension((PacketExtension)new NodeExtension(PubSubElementType.CREATE, nodeName));
        this.pendingCreateRequests.put(packetID, nodeName);
        this.timeoutTimer.schedule(new TimerTask(){

            public void run() {
                PubSubPublisher.this.pendingCreateRequests.remove(packetID);
            }
        }, 500L);
        this.send((IQ)request);
    }

    private void dispose() {
        this.timeoutTimer.cancel();
        this.timeoutTimer = null;
        this.listeners = null;
        this.nodes = null;
        this.pendingConfigureRequests = null;
        this.pendingCreateRequests = null;
        this.pendingPublishRequests = null;
        this.serviceName = null;
    }

    private void fireResponseCreateEvent(PubSubResponseListener.Response type) {
        for (PubSubResponseListener l : this.listeners) {
            l.onCreateNodeResponse(type);
        }
    }

    private void fireResponsePublishEvent(PubSubResponseListener.Response type, IQ iq) {
        for (PubSubResponseListener l : this.listeners) {
            l.onPublishResponse(type, iq);
        }
    }

    private void handleConfigureResponse(IQ response) {
        if (this.pendingConfigureRequests.remove(response.getPacketID()) != null) {
            this.fireResponseCreateEvent(PubSubResponseListener.Response.SUCCESS);
        }
    }

    private void handleCreateNodeResponse(IQ response) {
        String packetID = response.getPacketID();
        String nodeName = this.pendingCreateRequests.remove(packetID);
        if (nodeName != null) {
            this.nodes.add(nodeName);
            this.configureNode(nodeName);
        }
    }

    private void handleErrorResponse(IQ response) {
        XMPPError err = response.getError();
        String packetID = response.getPacketID();
        if (err != null) {
            XMPPError.Type errType = err.getType();
            String errCondition = err.getCondition();
            if (XMPPError.Type.CANCEL.equals((Object)errType) && (XMPPError.Condition.conflict.toString().equals(errCondition) || XMPPError.Condition.forbidden.toString().equals(errCondition)) || XMPPError.Type.AUTH.equals((Object)errType) && XMPPError.Condition.forbidden.toString().equals(errCondition)) {
                String nodeName;
                if (XMPPError.Condition.forbidden.toString().equals(errCondition)) {
                    logger.warn((Object)"Creating node failed with <forbidden/> error. Continuing anyway.");
                }
                if ((nodeName = this.pendingCreateRequests.remove(packetID)) != null) {
                    this.nodes.add(nodeName);
                    this.fireResponseCreateEvent(PubSubResponseListener.Response.SUCCESS);
                    return;
                }
            }
        }
        StringBuilder errMsg = new StringBuilder("Error received");
        String nodeName = this.pendingCreateRequests.remove(packetID);
        if (nodeName != null) {
            this.fireResponseCreateEvent(PubSubResponseListener.Response.FAIL);
            errMsg.append(" when creating the node: ");
        } else {
            nodeName = this.pendingConfigureRequests.remove(packetID);
            if (nodeName != null) {
                this.fireResponseCreateEvent(PubSubResponseListener.Response.SUCCESS);
                errMsg.append(" when configuring the node: ");
            } else {
                nodeName = this.pendingPublishRequests.remove(packetID);
                if (nodeName != null) {
                    this.fireResponsePublishEvent(PubSubResponseListener.Response.FAIL, response);
                    errMsg.append(" when publishing to the node: ");
                } else {
                    nodeName = null;
                }
            }
        }
        if (nodeName != null) {
            errMsg.append(nodeName);
        }
        errMsg.append(".");
        if (err != null) {
            errMsg.append(" Message: ").append(err.getMessage()).append(". Condition: ").append(err.getCondition()).append(". For packet with id: ").append(packetID).append(".");
        }
        logger.error((Object)errMsg);
    }

    private void handlePublishResponse(IQ response) {
        if (this.pendingPublishRequests.remove(response.getPacketID()) != null) {
            this.fireResponsePublishEvent(PubSubResponseListener.Response.SUCCESS, response);
        }
    }

    public void publish(String nodeName, PacketExtension ext) throws Exception {
        if (!this.nodes.contains(nodeName)) {
            throw new IllegalArgumentException("The node doesn't exists");
        }
        PubSub packet = new PubSub();
        packet.setTo(this.serviceName);
        packet.setType(IQ.Type.SET);
        final String packetID = IQ.nextID();
        packet.setPacketID(packetID);
        PayloadItem item = new PayloadItem(ext);
        packet.addExtension((PacketExtension)new PublishItem(nodeName, (Item)item));
        this.pendingPublishRequests.put(packetID, nodeName);
        this.timeoutTimer.schedule(new TimerTask(){

            public void run() {
                String nodeName = (String)PubSubPublisher.this.pendingPublishRequests.remove(packetID);
                if (nodeName != null) {
                    logger.error((Object)("Publish request timeout: " + nodeName));
                }
            }
        }, 500L);
        this.send((IQ)packet);
    }

    public void removeResponseListener(PubSubResponseListener l) {
        this.listeners.remove(l);
    }

    private void send(IQ iq) throws Exception {
        BundleContext bundleContext = StatsManagerBundleActivator.getBundleContext();
        if (bundleContext != null) {
            Collection components = ComponentImpl.getComponents((BundleContext)bundleContext);
            for (ComponentImpl component : components) {
                component.send(iq);
            }
        }
    }
}

