/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class MigrationNotice
extends ConnCommand {
    private static final int TYPE_HOST = 5;
    private static final int TYPE_COOKIE = 6;
    private final int[] families;
    private final String host;
    private final ByteBlock cookie;

    protected MigrationNotice(SnacPacket packet) {
        super(18);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        int familyCount = BinaryTools.getUShort((ByteBlock)snacData, (int)0);
        this.families = new int[familyCount];
        for (int i = 0; i < this.families.length; ++i) {
            this.families[i] = BinaryTools.getUShort((ByteBlock)snacData, (int)(2 + i * 2));
        }
        ByteBlock tlvBlock = snacData.subBlock(2 + familyCount * 2);
        ImmutableTlvChain chain = TlvTools.readChain(tlvBlock);
        this.host = chain.getString(5);
        this.cookie = chain.getLastTlv(6).getData();
    }

    public MigrationNotice(String host, ByteBlock cookie, int[] families) {
        super(18);
        this.families = families == null ? null : (int[])families.clone();
        this.host = host;
        this.cookie = cookie;
    }

    public final String getHost() {
        return this.host;
    }

    public final ByteBlock getCookie() {
        return this.cookie;
    }

    public final int[] getFamilies() {
        return this.families == null ? null : (int[])this.families.clone();
    }

    public void writeData(OutputStream out) throws IOException {
        int len = this.families == null ? 0 : this.families.length;
        BinaryTools.writeUShort((OutputStream)out, (int)len);
        if (this.families != null) {
            for (int family1 : this.families) {
                BinaryTools.writeUShort((OutputStream)out, (int)family1);
            }
        }
        if (this.host != null) {
            Tlv.getStringInstance(5, this.host).write(out);
        }
        if (this.cookie != null) {
            new Tlv(6, (Writable)this.cookie).write(out);
        }
    }

    public String toString() {
        return "MigrationNotice for " + (this.families == null ? -1 : this.families.length) + " families to " + this.host + " (cookie length=" + this.cookie.getLength() + ")";
    }
}

