/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hsqldb.util.Traceable;
import org.hsqldb.util.TransferDb;
import org.hsqldb.util.TransferHelper;
import org.hsqldb.util.TransferTable;

class PostgresTransferHelper
extends TransferHelper {
    private final int PostgreSQL = 0;
    private final int HSQLDB = 1;
    String[][] Funcs = new String[][]{{"now()", "'now'"}};

    PostgresTransferHelper() {
    }

    PostgresTransferHelper(TransferDb transferDb, Traceable traceable, String string) {
        super(transferDb, traceable, string);
    }

    int convertToType(int n) {
        if (n == 3) {
            n = 2;
            this.tracer.trace("Converted DECIMAL to NUMERIC");
        }
        return n;
    }

    String fixupColumnDefRead(TransferTable transferTable, ResultSetMetaData resultSetMetaData, String string, ResultSet resultSet, int n) throws SQLException {
        String string2 = new String("_" + resultSet.getString(4) + "_seq");
        int n2 = 31 - string2.length();
        string2 = transferTable.Stmts.sDestTable.length() > n2 ? transferTable.Stmts.sDestTable.substring(0, n2) + string2 : transferTable.Stmts.sDestTable + string2;
        String string3 = "nextval('\"" + string2 + "\"'";
        if (string.indexOf(string3) >= 0) {
            string = "SERIAL";
        }
        int n3 = 0;
        while (n3 < this.Funcs.length) {
            String string4 = this.Funcs[n3][0];
            int n4 = string.indexOf(string4);
            if (n4 >= 0) {
                String string5 = string.substring(0, n4);
                string5 = string5 + this.Funcs[n3][1];
                string = string5 = string5 + string.substring(n4 + string4.length());
            }
            ++n3;
        }
        return string;
    }

    String fixupColumnDefWrite(TransferTable transferTable, ResultSetMetaData resultSetMetaData, String string, ResultSet resultSet, int n) throws SQLException {
        if (string.equals("SERIAL")) {
            String string2 = new String("_" + resultSet.getString(4) + "_seq");
            int n2 = 31 - string2.length();
            string2 = transferTable.Stmts.sDestTable.length() > n2 ? transferTable.Stmts.sDestTable.substring(0, n2) + string2 : transferTable.Stmts.sDestTable + string2;
            String string3 = "DROP SEQUENCE " + string2 + ";";
            transferTable.Stmts.sDestDrop = transferTable.Stmts.sDestDrop + string3;
        }
        int n3 = 0;
        while (n3 < this.Funcs.length) {
            String string4 = this.Funcs[n3][1];
            int n4 = string.indexOf(string4);
            if (n4 >= 0) {
                String string5 = string.substring(0, n4);
                string5 = string5 + this.Funcs[n3][0];
                string = string5 = string5 + string.substring(n4 + string4.length());
            }
            ++n3;
        }
        return string;
    }

    void beginDataTransfer() {
        try {
            this.db.setAutoCommit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void endDataTransfer() {
        try {
            this.db.commit();
            this.db.execute("VACUUM ANALYZE");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

