/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import java.io.IOException;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.ScannerState;

final class Comment {
    private ScannerState state;
    private boolean skip;

    Comment(ScannerState scannerState) {
        this.state = scannerState;
        this.skip = true;
    }

    Comment(ScannerState scannerState, boolean bl) {
        this.state = scannerState;
        this.skip = bl;
    }

    private void ignoreData() throws IOException, ScannerException {
        while (true) {
            if (this.state.currentChar == '-') {
                this.state.checkedRead();
                if (this.state.currentChar == '-') {
                    this.state.checkedRead();
                    if (this.state.currentChar == '>') {
                        this.state.read();
                        this.state.pushToken(this.state.tokenFactory.createToken(7));
                        return;
                    }
                    throw new ScannerException(" Comments may not contain '--'", this.state);
                }
            }
            this.state.checkedRead();
        }
    }

    private void bufferData() throws IOException, ScannerException {
        int n = 0;
        this.state.mark();
        while (true) {
            if (this.state.currentChar == '-') {
                this.state.checkedRead();
                if (this.state.currentChar == '-') {
                    this.state.checkedRead();
                    if (this.state.currentChar == '>') {
                        this.state.read();
                        this.state.pushToken(this.state.createToken(7, n));
                        return;
                    }
                    throw new ScannerException("Comments may not contain '--'", this.state);
                }
                ++n;
            }
            this.state.checkedRead();
            ++n;
        }
    }

    void read() throws IOException, ScannerException {
        if (this.skip) {
            this.ignoreData();
        } else {
            this.bufferData();
        }
    }
}

