/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apache.ant.pack200;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Pack;

public class Pack200Task
extends Pack {
    private static final String ERRMSG_ZF = "zipfile attribute must end";
    protected static final String COM_PREFIX = "com.sun.java.util.jar.pack.";
    private boolean doRepack = false;
    private boolean doGZIP = false;
    private File p200ConfigFile = null;
    private HashMap<String, String> propMap = new HashMap();

    private void validate() throws BuildException {
        if (this.p200ConfigFile != null && (!this.p200ConfigFile.exists() || this.p200ConfigFile.isDirectory())) {
            throw new BuildException("Pack200 property file attribute must exist and not represent a directory!", this.getLocation());
        }
        if (this.doGZIP) {
            if (!this.zipFile.toString().toLowerCase().endsWith(".gz")) {
                throw new BuildException("zipfile attribute must end with .gz extension", this.getLocation());
            }
        } else if (this.doRepack) {
            if (!this.zipFile.toString().toLowerCase().endsWith(".jar")) {
                throw new BuildException("zipfile attribute must end with .jar extension", this.getLocation());
            }
        } else if (!this.zipFile.toString().toLowerCase().endsWith(".pack") && !this.zipFile.toString().toLowerCase().endsWith(".pac")) {
            throw new BuildException("zipfile attribute must endwith .pack or .pac extension", this.getLocation());
        }
    }

    public void setRepack(boolean value) {
        this.doRepack = value;
    }

    public void setGZIPOutput(boolean value) {
        this.doGZIP = value;
    }

    public void setStripDebug(String value) {
        this.propMap.put("com.sun.java.util.jar.pack.strip.debug", value);
    }

    public void setModificationTime(String value) {
        this.propMap.put("pack.modification.time", value);
    }

    public void setDeflateHint(String value) {
        this.propMap.put("pack.deflate.hint", value);
    }

    public void setKeepFileOrder(String value) {
        this.propMap.put("pack.keep.file.order", value);
    }

    public void setSegmentLimit(String value) {
        this.propMap.put("pack.segment.limit", value);
    }

    public void setEffort(String value) {
        this.propMap.put("pack.effort", value);
    }

    public void setUnknownAttribute(String value) {
        this.propMap.put("pack.unknown.attribute", value);
    }

    public void setConfigFile(File packConfig) {
        this.p200ConfigFile = packConfig;
    }

    public void setVerbose(String value) {
        this.propMap.put("com.sun.java.util.jar.pack.verbose", value);
    }

    protected void pack() {
        String statusStr = this.doRepack ? "Repack with Pack200" : "Packing with Pack200";
        System.out.println(statusStr);
        System.out.println("Source File :" + this.source);
        System.out.println("Dest.  File :" + this.zipFile);
        if (this.p200ConfigFile != null) {
            System.out.println("Config file :" + this.p200ConfigFile);
        }
        this.validate();
        File packFile = this.zipFile;
        try {
            Pack200.Packer pkr = Pack200.newPacker();
            pkr.properties().putAll(this.propMap);
            if (this.p200ConfigFile != null) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.p200ConfigFile));
                Properties pFile = new Properties();
                pFile.load(is);
                ((InputStream)is).close();
                for (Map.Entry<Object, Object> me : pFile.entrySet()) {
                    pkr.properties().put((String)me.getKey(), (String)me.getValue());
                }
            }
            if (this.doRepack) {
                this.doGZIP = false;
                packFile = new File(this.zipFile.toString() + ".tmp");
            }
            JarFile jarFile = new JarFile(this.source);
            FileOutputStream fos = new FileOutputStream(packFile);
            BufferedOutputStream os = this.doGZIP ? new BufferedOutputStream(new GZIPOutputStream(fos)) : new BufferedOutputStream(fos);
            pkr.pack(jarFile, (OutputStream)os);
            ((OutputStream)os).close();
            jarFile.close();
            if (this.doRepack) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(packFile));
                JarOutputStream jout = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.zipFile)));
                Pack200.Unpacker unpkr = Pack200.newUnpacker();
                unpkr.properties().putAll(this.propMap);
                if (this.p200ConfigFile != null) {
                    BufferedInputStream pc_is = new BufferedInputStream(new FileInputStream(this.p200ConfigFile));
                    Properties pFile = new Properties();
                    pFile.load(pc_is);
                    ((InputStream)pc_is).close();
                    for (Map.Entry<Object, Object> me : pFile.entrySet()) {
                        unpkr.properties().put((String)me.getKey(), (String)me.getValue());
                    }
                }
                unpkr.unpack((InputStream)is, jout);
                ((InputStream)is).close();
                jout.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new BuildException("Error in pack200");
        }
        finally {
            if (this.doRepack) {
                packFile.delete();
            }
        }
    }
}

