/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;

public class RemoveMeCmd
extends SsiCommand {
    private final String screenname;

    protected RemoveMeCmd(SnacPacket snacPacket) {
        super(22);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        StringBlock stringBlock = OscarTools.readScreenname(byteBlock);
        this.screenname = stringBlock != null ? stringBlock.getString() : null;
    }

    public RemoveMeCmd(String string) {
        super(22);
        this.screenname = string;
    }

    public final String getScreenname() {
        return this.screenname;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.screenname != null) {
            OscarTools.writeScreenname(outputStream, this.screenname);
        }
    }

    public String toString() {
        return "SsiRemoveMeCmd: screenname=" + this.screenname;
    }
}

