/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.AbstractIcbm;
import net.kano.joscar.snaccmd.icbm.MessageAck;
import net.kano.joscar.snaccmd.icbm.MissedMessagesCmd;
import net.kano.joscar.snaccmd.icbm.ParamInfoCmd;
import net.kano.joscar.snaccmd.icbm.RecvImIcbm;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.snaccmd.icbm.RecvTypingNotification;
import net.kano.joscar.snaccmd.icbm.RvResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientIcbmCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList(new CmdType(4, 5), new CmdType(4, 7), new CmdType(4, 20), new CmdType(4, 10), new CmdType(4, 12), new CmdType(4, 11));

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket snacPacket) {
        if (snacPacket.getFamily() != 4) {
            return null;
        }
        int n = snacPacket.getCommand();
        if (n == 5) {
            return new ParamInfoCmd(snacPacket);
        }
        if (n == 7) {
            int n2 = AbstractIcbm.getIcbmChannel(snacPacket);
            if (n2 == 1) {
                return new RecvImIcbm(snacPacket);
            }
            if (n2 == 2) {
                return new RecvRvIcbm(snacPacket);
            }
            return null;
        }
        if (n == 20) {
            return new RecvTypingNotification(snacPacket);
        }
        if (n == 10) {
            return new MissedMessagesCmd(snacPacket);
        }
        if (n == 12) {
            return new MessageAck(snacPacket);
        }
        if (n == 11) {
            return new RvResponse(snacPacket);
        }
        return null;
    }
}

