/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetExtraInfoCmd
extends ConnCommand {
    public static final int ICQSTATUS_NONE = -1;
    private static final int TYPE_ICQSTATUS = 6;
    private static final int TYPE_DATA = 29;
    private final long icqstatus;
    private final List<ExtraInfoBlock> blocks;

    protected SetExtraInfoCmd(SnacPacket snacPacket) {
        super(30);
        ByteBlock byteBlock = snacPacket.getData();
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock);
        Tlv tlv = immutableTlvChain.getLastTlv(6);
        this.icqstatus = tlv != null ? tlv.getDataAsUInt() : -1L;
        Tlv tlv2 = immutableTlvChain.getLastTlv(29);
        if (tlv2 != null) {
            ByteBlock byteBlock2 = tlv2.getData();
            this.blocks = ExtraInfoBlock.readExtraInfoBlocks(byteBlock2);
        } else {
            this.blocks = null;
        }
    }

    public SetExtraInfoCmd(long l) {
        this(l, null);
    }

    public SetExtraInfoCmd(ExtraInfoBlock ... extraInfoBlockArray) {
        this(Arrays.asList(extraInfoBlockArray));
    }

    public SetExtraInfoCmd(List<ExtraInfoBlock> list) {
        this(-1L, list);
    }

    public SetExtraInfoCmd(long l, List<ExtraInfoBlock> list) {
        super(30);
        DefensiveTools.checkRange(l, "icqstatus", -1L);
        this.icqstatus = l;
        this.blocks = DefensiveTools.getSafeListCopy(list, "blocks");
    }

    public final long getIcqStatus() {
        return this.icqstatus;
    }

    public final List<ExtraInfoBlock> getInfoBlocks() {
        return this.blocks;
    }

    @Override
    public void writeData(OutputStream outputStream) throws IOException {
        if (this.icqstatus != -1L) {
            Tlv.getUIntInstance(6, this.icqstatus).write(outputStream);
        }
        if (this.blocks != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (ExtraInfoBlock extraInfoBlock : this.blocks) {
                extraInfoBlock.write(byteArrayOutputStream);
            }
            new Tlv(29, ByteBlock.wrap(byteArrayOutputStream.toByteArray())).write(outputStream);
        }
    }

    public String toString() {
        return "SetExtraInfoCmd: blocks=" + (this.blocks == null ? null : this.blocks) + (this.icqstatus != -1L ? ", icqstatus=" + this.icqstatus : "");
    }
}

