/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.auth;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.auth.AuthRequest;
import net.kano.joscar.snaccmd.auth.KeyRequest;
import net.kano.joscar.snaccmd.auth.SecuridResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerAuthCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList(new CmdType(23, 6), new CmdType(23, 2), new CmdType(23, 11));

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket snacPacket) {
        if (snacPacket.getFamily() != 23) {
            return null;
        }
        int n = snacPacket.getCommand();
        if (n == 6) {
            return new KeyRequest(snacPacket);
        }
        if (n == 2) {
            return new AuthRequest(snacPacket);
        }
        if (n == 11) {
            return new SecuridResponse(snacPacket);
        }
        return null;
    }
}

