/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.core;

import java.io.IOException;
import java.io.Reader;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.taglibs.standard.tag.common.core.Util;

public class OutSupport
extends BodyTagSupport {
    protected Object value;
    protected String def;
    protected boolean escapeXml;
    private boolean needBody;

    public OutSupport() {
        this.init();
    }

    private void init() {
        this.def = null;
        this.value = null;
        this.escapeXml = true;
        this.needBody = false;
    }

    public void release() {
        super.release();
        this.init();
    }

    public int doStartTag() throws JspException {
        this.needBody = false;
        this.bodyContent = null;
        try {
            if (this.value != null) {
                OutSupport.out(this.pageContext, this.escapeXml, this.value);
                return 0;
            }
            if (this.def == null) {
                this.needBody = true;
                return 2;
            }
            if (this.def != null) {
                OutSupport.out(this.pageContext, this.escapeXml, this.def);
            }
            return 0;
        }
        catch (IOException ex) {
            throw new JspException(ex.toString(), (Throwable)ex);
        }
    }

    public int doEndTag() throws JspException {
        try {
            if (!this.needBody) {
                return 6;
            }
            if (this.bodyContent != null && this.bodyContent.getString() != null) {
                OutSupport.out(this.pageContext, this.escapeXml, this.bodyContent.getString().trim());
            }
            return 6;
        }
        catch (IOException ex) {
            throw new JspException(ex.toString(), (Throwable)ex);
        }
    }

    public static void out(PageContext pageContext, boolean escapeXml, Object obj) throws IOException {
        JspWriter w = pageContext.getOut();
        if (!escapeXml) {
            if (obj instanceof Reader) {
                int count;
                Reader reader = (Reader)obj;
                char[] buf = new char[4096];
                while ((count = reader.read(buf, 0, 4096)) != -1) {
                    w.write(buf, 0, count);
                }
            } else {
                w.write(obj.toString());
            }
        } else if (obj instanceof Reader) {
            int count;
            Reader reader = (Reader)obj;
            char[] buf = new char[4096];
            while ((count = reader.read(buf, 0, 4096)) != -1) {
                OutSupport.writeEscapedXml(buf, count, w);
            }
        } else {
            String text = obj.toString();
            OutSupport.writeEscapedXml(text.toCharArray(), text.length(), w);
        }
    }

    private static void writeEscapedXml(char[] buffer, int length, JspWriter w) throws IOException {
        int start = 0;
        for (int i = 0; i < length; ++i) {
            char[] escaped;
            char c = buffer[i];
            if (c > '>' || (escaped = Util.specialCharactersRepresentation[c]) == null) continue;
            if (start < i) {
                w.write(buffer, start, i - start);
            }
            w.write(escaped);
            start = i + 1;
        }
        if (start < length) {
            w.write(buffer, start, length - start);
        }
    }
}

