package chat.rocket.android.authentication.loginoptions.presentation

import chat.rocket.android.core.behaviours.LoadingView
import chat.rocket.android.core.behaviours.MessageView

interface LoginOptionsView : LoadingView, MessageView {

    // OAuth accounts.
    /**
     * Shows the "login by Facebook" view if it is enabled by the server settings.
     *
     * REMARK: We must set up the Facebook button listener before enabling it
     * [setupFacebookButtonListener].
     * @see [showAccountsView]
     */
    fun enableLoginByFacebook()

    /**
     * Setups the Facebook button.
     *
     * @param facebookOauthUrl The Facebook OAuth URL to authenticate with.
     * @param state A random string generated by the app, which you'll verify later
     * (to protect against forgery attacks).
     */
    fun setupFacebookButtonListener(facebookOauthUrl: String, state: String)

    /**
     * Shows the "login by Github" view if it is enabled by the server settings.
     *
     * REMARK: We must set up the Github button listener before enabling it
     * [setupGithubButtonListener].
     * @see [showAccountsView]
     */
    fun enableLoginByGithub()

    /**
     * Setups the Github button.
     *
     * @param githubUrl The Github OAuth URL to authenticate with.
     * @param state A random string generated by the app, which you'll verify later
     * (to protect against forgery attacks).
     */
    fun setupGithubButtonListener(githubUrl: String, state: String)

    /**
     * Shows the "login by Google" view if it is enabled by the server settings.
     *
     * REMARK: We must set up the Google button listener before enabling it
     * [setupGoogleButtonListener].
     * @see [showAccountsView]
     */
    fun enableLoginByGoogle()

    /**
     * Setups the Google button.
     *
     * @param googleUrl The Google OAuth URL to authenticate with.
     * @param state A random string generated by the app, which you'll verify later
     * (to protect against forgery attacks).
     */
    fun setupGoogleButtonListener(googleUrl: String, state: String)

    /**
     * Shows the "login by Linkedin" view if it is enabled by the server settings.
     *
     * REMARK: We must set up the Linkedin button listener before enabling it
     * [setupLinkedinButtonListener].
     * @see [showAccountsView]
     */
    fun enableLoginByLinkedin()

    /**
     * Setups the Linkedin button.
     *
     * @param linkedinUrl The Linkedin OAuth URL to authenticate with.
     * @param state A random string generated by the app, which you'll verify later
     * (to protect against forgery attacks).
     */
    fun setupLinkedinButtonListener(linkedinUrl: String, state: String)

    /**
     * Shows the "login by Gitlab" view if it is enabled by the server settings.
     *
     * REMARK: We must set up the Gitlab button listener before enabling it
     * [setupGitlabButtonListener].
     * @see [showAccountsView]
     */
    fun enableLoginByGitlab()

    /**
     * Setups the Gitlab button.
     *
     * @param gitlabUrl The Gitlab OAuth URL to authenticate with.
     * @param state A random string generated by the app, which you'll verify later
     * (to protect against forgery attacks).
     */
    fun setupGitlabButtonListener(gitlabUrl: String, state: String)

    /**
     * Shows the "login by WordPress" view if it is enabled by the server settings.
     *
     * REMARK: We must set up the Gitlab button listener before enabling it [setupWordpressButtonListener].
     */
    fun enableLoginByWordpress()

    /**
     * Setups the WordPress button when tapped.
     *
     * @param wordpressUrl The WordPress OAuth URL to authenticate with.
     * @param state A random string generated by the app, which you'll verify later (to protect against forgery attacks).
     */
    fun setupWordpressButtonListener(wordpressUrl: String, state: String)

    // CAS account.
    /**
     * Shows the CAS button if the sign in/sign out via CAS protocol is enabled by the server
     * settings.
     *
     * REMARK: We must set up the CAS button listener before showing it [setupCasButtonListener].
     * @see [showAccountsView]
     */
    fun enableLoginByCas()

    /**
     * Setups the CAS button.
     *
     * @param casUrl The CAS URL to authenticate with.
     * @param casToken The requested token to be sent to the CAS server.
     */
    fun setupCasButtonListener(casUrl: String, casToken: String)

    // Custom OAuth account.
    /**
     * Adds a custom OAuth button in the accounts container.
     *
     * @customOauthUrl The custom OAuth url.
     * @state A random string generated by the app, which you'll verify later
     * (to protect against forgery attacks).
     * @serviceName The custom OAuth service name.
     * @serviceNameColor The custom OAuth service name color (just stylizing).
     * @buttonColor The custom OAuth button color (just stylizing).
     * @see [showAccountsView]
     */
    fun addCustomOauthButton(
        customOauthUrl: String,
        state: String,
        serviceName: String,
        serviceNameColor: Int,
        buttonColor: Int
    )

    // SAML account.
    /**
     *  Adds a SAML button in the accounts container.
     *
     * @samlUrl The SAML url.
     * @serviceName The SAML service name.
     * @serviceNameColor The SAML service name color (just stylizing).
     * @buttonColor The SAML button color (just stylizing).
     * @see [showAccountsView]
     */
    fun addSamlButton(
        samlUrl: String,
        samlToken: String,
        serviceName: String,
        serviceNameColor: Int,
        buttonColor: Int
    )

    /**
     * Shows the accounts container view if there is at least a login via
     * OAuth/Custom OAuth/CAS/SAML account enabled by the server settings.
     *
     * REMARK: We must show at maximum *three* accounts views ([enableLoginByFacebook],
     * [enableLoginByGithub], [enableLoginByGoogle], [enableLoginByLinkedin], [enableLoginByGitlab],
     * [enableLoginByCas], [addCustomOauthButton] or [addSamlButton]) for the accounts container view.
     * If the enabled accounts exceeds 3 we must set up the [setupExpandAccountsView] to show the
     * remaining view(s).
     */
    fun showAccountsView()

    /**
     * Setups the expand accounts view to show more accounts views (expanding the accounts view
     * interface to show the remaining view(s)).
     */
    fun setupExpandAccountsView()

    /**
     * Shows the "login with e-mail" view if it is enabled by the server settings.
     */
    fun showLoginWithEmailButton()

    /**
     * Shows the "Create new account" view if it is enabled by the server settings.
     */
    fun showCreateNewAccountButton()
}
