package chat.rocket.android.authentication.loginoptions.presentation

import chat.rocket.android.core.behaviours.LoadingView
import chat.rocket.android.core.behaviours.MessageView

interface LoginOptionsView : LoadingView, MessageView {
    /**
     * Shows the "login by Facebook view if it is enable by the server settings.
     */
    fun enableLoginByFacebook()

    /**
     * Shows the "login by Github" view if it is enable by the server settings.
     *
     * REMARK: We must set up the Github button listener before enabling it [setupGithubButtonListener].
     */
    fun enableLoginByGithub()

    /**
     * Setups the Github button when tapped.
     *
     * @param githubUrl The Github OAuth URL to authenticate with.
     * @param state A random string generated by the app, which you'll verify later (to protect against forgery attacks).
     */
    fun setupGithubButtonListener(githubUrl: String, state: String)

    /**
     * Shows the "login by Google" view if it is enable by the server settings.
     *
     * REMARK: We must set up the Google button listener before enabling it [setupGoogleButtonListener].
     */
    fun enableLoginByGoogle()

    /**
     * Setups the Google button when tapped.
     *
     * @param googleUrl The Google OAuth URL to authenticate with.
     * @param state A random string generated by the app, which you'll verify later (to protect against forgery attacks).
     */
    fun setupGoogleButtonListener(googleUrl: String, state: String)

    /**
     * Shows the "login by Linkedin" view if it is enable by the server settings.
     *
     * REMARK: We must set up the Linkedin button listener before enabling it [setupLinkedinButtonListener].
     */
    fun enableLoginByLinkedin()

    /**
     * Setups the Linkedin button when tapped.
     *
     * @param linkedinUrl The Linkedin OAuth URL to authenticate with.
     * @param state A random string generated by the app, which you'll verify later (to protect against forgery attacks).
     */
    fun setupLinkedinButtonListener(linkedinUrl: String, state: String)

    /**
     * Setups the Facebook button when tapped.
     *
     * @param facebookOauthUrl The Facebook OAuth URL to authenticate with.
     * @param state A random string generated by the app, which you'll verify later (to protect against forgery attacks).
     */
    fun setupFacebookButtonListener(facebookOauthUrl: String, state: String)

    /**
     * Shows the "login by Gitlab" view if it is enable by the server settings.
     *
     * REMARK: We must set up the Gitlab button listener before enabling it [setupGitlabButtonListener].
     */
    fun enableLoginByGitlab()

    /**
     * Setups the Gitlab button when tapped.
     *
     * @param gitlabUrl The Gitlab OAuth URL to authenticate with.
     * @param state A random string generated by the app, which you'll verify later (to protect against forgery attacks).
     */
    fun setupGitlabButtonListener(gitlabUrl: String, state: String)
}
