/*
 * Decompiled with CFR 0.152.
 */
package chat.rocket.core.model;

import chat.rocket.common.internal.ISO8601Date;
import chat.rocket.common.model.BaseRoom;
import chat.rocket.common.model.SimpleUser;
import chat.rocket.core.model.Message;
import chat.rocket.core.model.Room;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import se.ansman.kotshi.KotshiUtils;

public final class KotshiRoomJsonAdapter
extends JsonAdapter<Room> {
    private static final JsonReader.Options OPTIONS = JsonReader.Options.of((String[])new String[]{"_id", "t", "u", "name", "fname", "ro", "_updatedAt", "topic", "announcement", "lastMessage"});
    private final JsonAdapter<BaseRoom.RoomType> adapter0;
    private final JsonAdapter<SimpleUser> adapter1;
    private final JsonAdapter<Long> adapter2;
    private final JsonAdapter<Message> adapter3;

    public KotshiRoomJsonAdapter(Moshi moshi) {
        this.adapter0 = moshi.adapter(BaseRoom.RoomType.class);
        this.adapter1 = moshi.adapter(SimpleUser.class);
        this.adapter2 = moshi.adapter(Long.class, ISO8601Date.class);
        this.adapter3 = moshi.adapter(Message.class);
    }

    public void toJson(JsonWriter writer, Room value) throws IOException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        writer.name("_id");
        writer.value(value.getId());
        writer.name("t");
        this.adapter0.toJson(writer, (Object)value.getType());
        writer.name("u");
        this.adapter1.toJson(writer, (Object)value.getUser());
        writer.name("name");
        writer.value(value.getName());
        writer.name("fname");
        writer.value(value.getFullName());
        writer.name("ro");
        writer.value(value.getReadonly());
        writer.name("_updatedAt");
        this.adapter2.toJson(writer, (Object)value.getUpdatedAt());
        writer.name("topic");
        writer.value(value.getTopic());
        writer.name("announcement");
        writer.value(value.getAnnouncement());
        writer.name("lastMessage");
        this.adapter3.toJson(writer, (Object)value.getLastMessage());
        writer.endObject();
    }

    public Room fromJson(JsonReader reader) throws IOException {
        if (reader.peek() == JsonReader.Token.NULL) {
            return (Room)reader.nextNull();
        }
        reader.beginObject();
        String id = null;
        BaseRoom.RoomType type = null;
        SimpleUser user = null;
        String name = null;
        String fullName = null;
        boolean readonly = false;
        boolean readonlyIsSet = false;
        Long updatedAt = null;
        String topic = null;
        String announcement = null;
        Message lastMessage = null;
        block13: while (reader.hasNext()) {
            switch (reader.selectName(OPTIONS)) {
                case 0: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block13;
                    }
                    id = reader.nextString();
                    continue block13;
                }
                case 1: {
                    type = (BaseRoom.RoomType)this.adapter0.fromJson(reader);
                    continue block13;
                }
                case 2: {
                    user = (SimpleUser)this.adapter1.fromJson(reader);
                    continue block13;
                }
                case 3: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block13;
                    }
                    name = reader.nextString();
                    continue block13;
                }
                case 4: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block13;
                    }
                    fullName = reader.nextString();
                    continue block13;
                }
                case 5: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block13;
                    }
                    readonly = reader.nextBoolean();
                    readonlyIsSet = true;
                    continue block13;
                }
                case 6: {
                    updatedAt = (Long)this.adapter2.fromJson(reader);
                    continue block13;
                }
                case 7: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block13;
                    }
                    topic = reader.nextString();
                    continue block13;
                }
                case 8: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block13;
                    }
                    announcement = reader.nextString();
                    continue block13;
                }
                case 9: {
                    lastMessage = (Message)this.adapter3.fromJson(reader);
                    continue block13;
                }
                case -1: {
                    reader.nextName();
                    reader.skipValue();
                    continue block13;
                }
            }
        }
        reader.endObject();
        StringBuilder stringBuilder = null;
        if (id == null) {
            stringBuilder = KotshiUtils.appendNullableError(stringBuilder, (String)"id");
        }
        if (type == null) {
            stringBuilder = KotshiUtils.appendNullableError((StringBuilder)stringBuilder, (String)"type");
        }
        if (!readonlyIsSet) {
            readonly = false;
        }
        if (stringBuilder != null) {
            throw new NullPointerException(stringBuilder.toString());
        }
        return new Room(id, type, user, name, fullName, readonly, updatedAt, topic, announcement, lastMessage);
    }
}

