/*
 * Decompiled with CFR 0.152.
 */
package chat.rocket.core.internal.model;

import chat.rocket.core.internal.model.UserPayload;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import java.io.IOException;
import se.ansman.kotshi.KotshiUtils;

public final class KotshiUserPayloadJsonAdapter
extends JsonAdapter<UserPayload> {
    private static final JsonReader.Options OPTIONS = JsonReader.Options.of((String[])new String[]{"email", "name", "pass", "username"});

    public void toJson(JsonWriter writer, UserPayload value) throws IOException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        writer.name("email");
        writer.value(value.getEmail());
        writer.name("name");
        writer.value(value.getName());
        writer.name("pass");
        writer.value(value.getPass());
        writer.name("username");
        writer.value(value.getUsername());
        writer.endObject();
    }

    public UserPayload fromJson(JsonReader reader) throws IOException {
        if (reader.peek() == JsonReader.Token.NULL) {
            return (UserPayload)reader.nextNull();
        }
        reader.beginObject();
        String email = null;
        String name = null;
        String pass = null;
        String username = null;
        block7: while (reader.hasNext()) {
            switch (reader.selectName(OPTIONS)) {
                case 0: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block7;
                    }
                    email = reader.nextString();
                    continue block7;
                }
                case 1: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block7;
                    }
                    name = reader.nextString();
                    continue block7;
                }
                case 2: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block7;
                    }
                    pass = reader.nextString();
                    continue block7;
                }
                case 3: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block7;
                    }
                    username = reader.nextString();
                    continue block7;
                }
                case -1: {
                    reader.nextName();
                    reader.skipValue();
                    continue block7;
                }
            }
        }
        reader.endObject();
        StringBuilder stringBuilder = null;
        if (email == null) {
            stringBuilder = KotshiUtils.appendNullableError(stringBuilder, (String)"email");
        }
        if (name == null) {
            stringBuilder = KotshiUtils.appendNullableError((StringBuilder)stringBuilder, (String)"name");
        }
        if (pass == null) {
            stringBuilder = KotshiUtils.appendNullableError((StringBuilder)stringBuilder, (String)"pass");
        }
        if (username == null) {
            stringBuilder = KotshiUtils.appendNullableError((StringBuilder)stringBuilder, (String)"username");
        }
        if (stringBuilder != null) {
            throw new NullPointerException(stringBuilder.toString());
        }
        return new UserPayload(email, name, pass, username);
    }
}

