/*
 * Decompiled with CFR 0.152.
 */
package chat.rocket.core.internal.model;

import chat.rocket.common.internal.ISO8601Date;
import chat.rocket.common.model.BaseRoom;
import chat.rocket.common.model.SimpleUser;
import chat.rocket.core.internal.model.Subscription;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import se.ansman.kotshi.KotshiUtils;

public final class KotshiSubscriptionJsonAdapter
extends JsonAdapter<Subscription> {
    private static final JsonReader.Options OPTIONS = JsonReader.Options.of((String[])new String[]{"rid", "_id", "t", "u", "name", "fname", "ro", "ts", "lm", "_updatedAt", "default", "open", "alert", "unread", "userMentions", "groupMentions"});
    private final JsonAdapter<BaseRoom.RoomType> adapter0;
    private final JsonAdapter<SimpleUser> adapter1;
    private final JsonAdapter<Long> adapter2;

    public KotshiSubscriptionJsonAdapter(Moshi moshi) {
        this.adapter0 = moshi.adapter(BaseRoom.RoomType.class);
        this.adapter1 = moshi.adapter(SimpleUser.class);
        this.adapter2 = moshi.adapter(Long.class, ISO8601Date.class);
    }

    public void toJson(JsonWriter writer, Subscription value) throws IOException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        writer.name("rid");
        writer.value(value.getRoomId());
        writer.name("_id");
        writer.value(value.getId());
        writer.name("t");
        this.adapter0.toJson(writer, (Object)value.getType());
        writer.name("u");
        this.adapter1.toJson(writer, (Object)value.getUser());
        writer.name("name");
        writer.value(value.getName());
        writer.name("fname");
        writer.value(value.getFullName());
        writer.name("ro");
        writer.value(value.getReadonly());
        writer.name("ts");
        this.adapter2.toJson(writer, (Object)value.getTimestamp());
        writer.name("lm");
        this.adapter2.toJson(writer, (Object)value.getLastModified());
        writer.name("_updatedAt");
        this.adapter2.toJson(writer, (Object)value.getUpdatedAt());
        writer.name("default");
        writer.value(value.isDefault());
        writer.name("open");
        writer.value(value.getOpen());
        writer.name("alert");
        writer.value(value.getAlert());
        writer.name("unread");
        writer.value(value.getUnread());
        writer.name("userMentions");
        writer.value((Number)value.getUserMentions());
        writer.name("groupMentions");
        writer.value((Number)value.getGroupMentions());
        writer.endObject();
    }

    public Subscription fromJson(JsonReader reader) throws IOException {
        if (reader.peek() == JsonReader.Token.NULL) {
            return (Subscription)reader.nextNull();
        }
        reader.beginObject();
        String roomId = null;
        String id = null;
        BaseRoom.RoomType type = null;
        SimpleUser user = null;
        String name = null;
        String fullName = null;
        Boolean readonly = null;
        Long timestamp = null;
        Long lastModified = null;
        Long updatedAt = null;
        boolean isDefault = false;
        boolean isDefaultIsSet = false;
        boolean open = false;
        boolean openIsSet = false;
        boolean alert = false;
        boolean alertIsSet = false;
        long unread = 0L;
        boolean unreadIsSet = false;
        Long userMentions = null;
        Long groupMentions = null;
        block19: while (reader.hasNext()) {
            switch (reader.selectName(OPTIONS)) {
                case 0: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block19;
                    }
                    roomId = reader.nextString();
                    continue block19;
                }
                case 1: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block19;
                    }
                    id = reader.nextString();
                    continue block19;
                }
                case 2: {
                    type = (BaseRoom.RoomType)this.adapter0.fromJson(reader);
                    continue block19;
                }
                case 3: {
                    user = (SimpleUser)this.adapter1.fromJson(reader);
                    continue block19;
                }
                case 4: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block19;
                    }
                    name = reader.nextString();
                    continue block19;
                }
                case 5: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block19;
                    }
                    fullName = reader.nextString();
                    continue block19;
                }
                case 6: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block19;
                    }
                    readonly = reader.nextBoolean();
                    continue block19;
                }
                case 7: {
                    timestamp = (Long)this.adapter2.fromJson(reader);
                    continue block19;
                }
                case 8: {
                    lastModified = (Long)this.adapter2.fromJson(reader);
                    continue block19;
                }
                case 9: {
                    updatedAt = (Long)this.adapter2.fromJson(reader);
                    continue block19;
                }
                case 10: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block19;
                    }
                    isDefault = reader.nextBoolean();
                    isDefaultIsSet = true;
                    continue block19;
                }
                case 11: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block19;
                    }
                    open = reader.nextBoolean();
                    openIsSet = true;
                    continue block19;
                }
                case 12: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block19;
                    }
                    alert = reader.nextBoolean();
                    alertIsSet = true;
                    continue block19;
                }
                case 13: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block19;
                    }
                    unread = reader.nextLong();
                    unreadIsSet = true;
                    continue block19;
                }
                case 14: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block19;
                    }
                    userMentions = reader.nextLong();
                    continue block19;
                }
                case 15: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block19;
                    }
                    groupMentions = reader.nextLong();
                    continue block19;
                }
                case -1: {
                    reader.nextName();
                    reader.skipValue();
                    continue block19;
                }
            }
        }
        reader.endObject();
        StringBuilder stringBuilder = null;
        if (roomId == null) {
            stringBuilder = KotshiUtils.appendNullableError(stringBuilder, (String)"roomId");
        }
        if (id == null) {
            stringBuilder = KotshiUtils.appendNullableError((StringBuilder)stringBuilder, (String)"id");
        }
        if (type == null) {
            stringBuilder = KotshiUtils.appendNullableError((StringBuilder)stringBuilder, (String)"type");
        }
        if (!isDefaultIsSet) {
            isDefault = false;
        }
        if (!openIsSet) {
            stringBuilder = KotshiUtils.appendNullableError((StringBuilder)stringBuilder, (String)"open");
        }
        if (!alertIsSet) {
            stringBuilder = KotshiUtils.appendNullableError((StringBuilder)stringBuilder, (String)"alert");
        }
        if (!unreadIsSet) {
            stringBuilder = KotshiUtils.appendNullableError((StringBuilder)stringBuilder, (String)"unread");
        }
        if (stringBuilder != null) {
            throw new NullPointerException(stringBuilder.toString());
        }
        return new Subscription(roomId, id, type, user, name, fullName, readonly, timestamp, lastModified, updatedAt, isDefault, open, alert, unread, userMentions, groupMentions);
    }
}

