/*
 * Decompiled with CFR 0.152.
 */
package chat.rocket.core.model;

import chat.rocket.core.model.ParsedUrl;
import chat.rocket.core.model.Url;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import se.ansman.kotshi.KotshiUtils;

public final class KotshiUrlJsonAdapter
extends JsonAdapter<Url> {
    private static final JsonReader.Options OPTIONS = JsonReader.Options.of((String[])new String[]{"url", "meta", "headers", "parsedUrl", "ignoreParse"});
    private final JsonAdapter<Map<String, String>> adapter0;
    private final JsonAdapter<ParsedUrl> adapter1;

    public KotshiUrlJsonAdapter(Moshi moshi) {
        this.adapter0 = moshi.adapter((Type)Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, String.class}));
        this.adapter1 = moshi.adapter(ParsedUrl.class);
    }

    public void toJson(JsonWriter writer, Url value) throws IOException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        writer.name("url");
        writer.value(value.getUrl());
        writer.name("meta");
        this.adapter0.toJson(writer, value.getMeta());
        writer.name("headers");
        this.adapter0.toJson(writer, value.getHeaders());
        writer.name("parsedUrl");
        this.adapter1.toJson(writer, (Object)value.getParsedUrl());
        writer.name("ignoreParse");
        writer.value(value.getIgnoreParse());
        writer.endObject();
    }

    public Url fromJson(JsonReader reader) throws IOException {
        if (reader.peek() == JsonReader.Token.NULL) {
            return (Url)reader.nextNull();
        }
        reader.beginObject();
        String url = null;
        Map meta = null;
        Map headers = null;
        ParsedUrl parsedUrl = null;
        boolean ignoreParse = false;
        boolean ignoreParseIsSet = false;
        block8: while (reader.hasNext()) {
            switch (reader.selectName(OPTIONS)) {
                case 0: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block8;
                    }
                    url = reader.nextString();
                    continue block8;
                }
                case 1: {
                    meta = (Map)this.adapter0.fromJson(reader);
                    continue block8;
                }
                case 2: {
                    headers = (Map)this.adapter0.fromJson(reader);
                    continue block8;
                }
                case 3: {
                    parsedUrl = (ParsedUrl)this.adapter1.fromJson(reader);
                    continue block8;
                }
                case 4: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block8;
                    }
                    ignoreParse = reader.nextBoolean();
                    ignoreParseIsSet = true;
                    continue block8;
                }
                case -1: {
                    reader.nextName();
                    reader.skipValue();
                    continue block8;
                }
            }
        }
        reader.endObject();
        StringBuilder stringBuilder = null;
        if (url == null) {
            stringBuilder = KotshiUtils.appendNullableError(stringBuilder, (String)"url");
        }
        if (!ignoreParseIsSet) {
            ignoreParse = false;
        }
        if (stringBuilder != null) {
            throw new NullPointerException(stringBuilder.toString());
        }
        return new Url(url, meta, headers, parsedUrl, ignoreParse);
    }
}

