/*
 * Decompiled with CFR 0.152.
 */
package chat.rocket.core.model;

import chat.rocket.common.model.BaseUser;
import chat.rocket.core.model.Email;
import chat.rocket.core.model.Myself;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import se.ansman.kotshi.KotshiUtils;

public final class KotshiMyselfJsonAdapter
extends JsonAdapter<Myself> {
    private static final JsonReader.Options OPTIONS = JsonReader.Options.of((String[])new String[]{"_id", "username", "name", "status", "statusConnection", "utcOffset", "active", "emails"});
    private final JsonAdapter<BaseUser.Status> adapter0;
    private final JsonAdapter<List<Email>> adapter1;

    public KotshiMyselfJsonAdapter(Moshi moshi) {
        this.adapter0 = moshi.adapter(BaseUser.Status.class);
        this.adapter1 = moshi.adapter((Type)Types.newParameterizedType(List.class, (Type[])new Type[]{Email.class}));
    }

    public void toJson(JsonWriter writer, Myself value) throws IOException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        writer.name("_id");
        writer.value(value.getId());
        writer.name("username");
        writer.value(value.getUsername());
        writer.name("name");
        writer.value(value.getName());
        writer.name("status");
        this.adapter0.toJson(writer, (Object)value.getStatus());
        writer.name("statusConnection");
        this.adapter0.toJson(writer, (Object)value.getStatusConnection());
        writer.name("utcOffset");
        writer.value((double)value.getUtcOffset());
        writer.name("active");
        writer.value(value.getActive());
        writer.name("emails");
        this.adapter1.toJson(writer, value.getEmails());
        writer.endObject();
    }

    public Myself fromJson(JsonReader reader) throws IOException {
        if (reader.peek() == JsonReader.Token.NULL) {
            return (Myself)reader.nextNull();
        }
        reader.beginObject();
        String id = null;
        String username = null;
        String name = null;
        BaseUser.Status status = null;
        BaseUser.Status statusConnection = null;
        float utcOffset = 0.0f;
        boolean utcOffsetIsSet = false;
        boolean active = false;
        boolean activeIsSet = false;
        List emails = null;
        block11: while (reader.hasNext()) {
            switch (reader.selectName(OPTIONS)) {
                case 0: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block11;
                    }
                    id = reader.nextString();
                    continue block11;
                }
                case 1: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block11;
                    }
                    username = reader.nextString();
                    continue block11;
                }
                case 2: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block11;
                    }
                    name = reader.nextString();
                    continue block11;
                }
                case 3: {
                    status = (BaseUser.Status)this.adapter0.fromJson(reader);
                    continue block11;
                }
                case 4: {
                    statusConnection = (BaseUser.Status)this.adapter0.fromJson(reader);
                    continue block11;
                }
                case 5: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block11;
                    }
                    utcOffset = KotshiUtils.nextFloat((JsonReader)reader);
                    utcOffsetIsSet = true;
                    continue block11;
                }
                case 6: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block11;
                    }
                    active = reader.nextBoolean();
                    activeIsSet = true;
                    continue block11;
                }
                case 7: {
                    emails = (List)this.adapter1.fromJson(reader);
                    continue block11;
                }
                case -1: {
                    reader.nextName();
                    reader.skipValue();
                    continue block11;
                }
            }
        }
        reader.endObject();
        StringBuilder stringBuilder = null;
        if (id == null) {
            stringBuilder = KotshiUtils.appendNullableError(stringBuilder, (String)"id");
        }
        if (!utcOffsetIsSet) {
            stringBuilder = KotshiUtils.appendNullableError((StringBuilder)stringBuilder, (String)"utcOffset");
        }
        if (!activeIsSet) {
            stringBuilder = KotshiUtils.appendNullableError((StringBuilder)stringBuilder, (String)"active");
        }
        if (stringBuilder != null) {
            throw new NullPointerException(stringBuilder.toString());
        }
        return new Myself(id, username, name, status, statusConnection, utcOffset, active, emails);
    }
}

