/*
 * Decompiled with CFR 0.152.
 */
package chat.rocket.core.model;

import chat.rocket.common.internal.ISO8601Date;
import chat.rocket.common.model.SimpleRoom;
import chat.rocket.common.model.SimpleUser;
import chat.rocket.core.model.Message;
import chat.rocket.core.model.Url;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import se.ansman.kotshi.KotshiUtils;

public final class KotshiMessageJsonAdapter
extends JsonAdapter<Message> {
    private static final JsonReader.Options OPTIONS = JsonReader.Options.of((String[])new String[]{"_id", "rid", "msg", "ts", "u", "_updatedAt", "editedAt", "editedBy", "alias", "avatar", "groupable", "parseUrls", "urls", "mentions", "channels"});
    private final JsonAdapter<Long> adapter0;
    private final JsonAdapter<SimpleUser> adapter1;
    private final JsonAdapter<Long> adapter2;
    private final JsonAdapter<List<Url>> adapter3;
    private final JsonAdapter<List<SimpleUser>> adapter4;
    private final JsonAdapter<List<SimpleRoom>> adapter5;

    public KotshiMessageJsonAdapter(Moshi moshi) {
        this.adapter0 = moshi.adapter(Long.TYPE, ISO8601Date.class);
        this.adapter1 = moshi.adapter(SimpleUser.class);
        this.adapter2 = moshi.adapter(Long.class, ISO8601Date.class);
        this.adapter3 = moshi.adapter((Type)Types.newParameterizedType(List.class, (Type[])new Type[]{Url.class}));
        this.adapter4 = moshi.adapter((Type)Types.newParameterizedType(List.class, (Type[])new Type[]{SimpleUser.class}));
        this.adapter5 = moshi.adapter((Type)Types.newParameterizedType(List.class, (Type[])new Type[]{SimpleRoom.class}));
    }

    public void toJson(JsonWriter writer, Message value) throws IOException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        writer.name("_id");
        writer.value(value.getId());
        writer.name("rid");
        writer.value(value.getRoomId());
        writer.name("msg");
        writer.value(value.getMessage());
        writer.name("ts");
        this.adapter0.toJson(writer, (Object)value.getTimestamp());
        writer.name("u");
        this.adapter1.toJson(writer, (Object)value.getSender());
        writer.name("_updatedAt");
        this.adapter0.toJson(writer, (Object)value.getUpdatedAt());
        writer.name("editedAt");
        this.adapter2.toJson(writer, (Object)value.getEditedAt());
        writer.name("editedBy");
        this.adapter1.toJson(writer, (Object)value.getEditedBy());
        writer.name("alias");
        writer.value(value.getSenderAlias());
        writer.name("avatar");
        writer.value(value.getAvatar());
        writer.name("groupable");
        writer.value(value.getGroupable());
        writer.name("parseUrls");
        writer.value(value.getParseUrls());
        writer.name("urls");
        this.adapter3.toJson(writer, value.getUrls());
        writer.name("mentions");
        this.adapter4.toJson(writer, value.getMentions());
        writer.name("channels");
        this.adapter5.toJson(writer, value.getChannels());
        writer.endObject();
    }

    public Message fromJson(JsonReader reader) throws IOException {
        if (reader.peek() == JsonReader.Token.NULL) {
            return (Message)reader.nextNull();
        }
        reader.beginObject();
        String id = null;
        String roomId = null;
        String message = null;
        Long timestamp = null;
        SimpleUser sender = null;
        Long updatedAt = null;
        Long editedAt = null;
        SimpleUser editedBy = null;
        String senderAlias = null;
        String avatar = null;
        boolean groupable = false;
        boolean groupableIsSet = false;
        boolean parseUrls = false;
        boolean parseUrlsIsSet = false;
        List urls = null;
        List mentions = null;
        List channels = null;
        block18: while (reader.hasNext()) {
            switch (reader.selectName(OPTIONS)) {
                case 0: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block18;
                    }
                    id = reader.nextString();
                    continue block18;
                }
                case 1: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block18;
                    }
                    roomId = reader.nextString();
                    continue block18;
                }
                case 2: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block18;
                    }
                    message = reader.nextString();
                    continue block18;
                }
                case 3: {
                    timestamp = (Long)this.adapter0.fromJson(reader);
                    continue block18;
                }
                case 4: {
                    sender = (SimpleUser)this.adapter1.fromJson(reader);
                    continue block18;
                }
                case 5: {
                    updatedAt = (Long)this.adapter0.fromJson(reader);
                    continue block18;
                }
                case 6: {
                    editedAt = (Long)this.adapter2.fromJson(reader);
                    continue block18;
                }
                case 7: {
                    editedBy = (SimpleUser)this.adapter1.fromJson(reader);
                    continue block18;
                }
                case 8: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block18;
                    }
                    senderAlias = reader.nextString();
                    continue block18;
                }
                case 9: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block18;
                    }
                    avatar = reader.nextString();
                    continue block18;
                }
                case 10: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block18;
                    }
                    groupable = reader.nextBoolean();
                    groupableIsSet = true;
                    continue block18;
                }
                case 11: {
                    if (reader.peek() == JsonReader.Token.NULL) {
                        reader.nextNull();
                        continue block18;
                    }
                    parseUrls = reader.nextBoolean();
                    parseUrlsIsSet = true;
                    continue block18;
                }
                case 12: {
                    urls = (List)this.adapter3.fromJson(reader);
                    continue block18;
                }
                case 13: {
                    mentions = (List)this.adapter4.fromJson(reader);
                    continue block18;
                }
                case 14: {
                    channels = (List)this.adapter5.fromJson(reader);
                    continue block18;
                }
                case -1: {
                    reader.nextName();
                    reader.skipValue();
                    continue block18;
                }
            }
        }
        reader.endObject();
        StringBuilder stringBuilder = null;
        if (id == null) {
            stringBuilder = KotshiUtils.appendNullableError(stringBuilder, (String)"id");
        }
        if (roomId == null) {
            stringBuilder = KotshiUtils.appendNullableError((StringBuilder)stringBuilder, (String)"roomId");
        }
        if (message == null) {
            stringBuilder = KotshiUtils.appendNullableError((StringBuilder)stringBuilder, (String)"message");
        }
        if (timestamp == null) {
            stringBuilder = KotshiUtils.appendNullableError((StringBuilder)stringBuilder, (String)"timestamp");
        }
        if (updatedAt == null) {
            stringBuilder = KotshiUtils.appendNullableError((StringBuilder)stringBuilder, (String)"updatedAt");
        }
        if (!groupableIsSet) {
            groupable = false;
        }
        if (!parseUrlsIsSet) {
            parseUrls = false;
        }
        if (stringBuilder != null) {
            throw new NullPointerException(stringBuilder.toString());
        }
        return new Message(id, roomId, message, timestamp, sender, updatedAt, editedAt, editedBy, senderAlias, avatar, groupable, parseUrls, urls, mentions, channels);
    }
}

