/*
 * Decompiled with CFR 0.152.
 */
package chat.rocket.core.internal.rest;

import chat.rocket.common.RocketChatApiException;
import chat.rocket.common.RocketChatAuthException;
import chat.rocket.common.RocketChatException;
import chat.rocket.common.RocketChatInvalidResponseException;
import chat.rocket.common.RocketChatNetworkErrorException;
import chat.rocket.common.RocketChatTwoFactorException;
import chat.rocket.common.internal.AuthenticationErrorMessage;
import chat.rocket.common.internal.ErrorMessage;
import chat.rocket.common.model.BaseRoom;
import chat.rocket.common.model.Token;
import chat.rocket.common.util.CommonExtensionsKt;
import chat.rocket.common.util.Logger;
import chat.rocket.core.RocketChatClient;
import chat.rocket.core.internal.rest.RestClientKt$WhenMappings;
import chat.rocket.core.internal.rest.RestClientKt$handleRestCall$;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.experimental.Continuation;
import kotlin.coroutines.experimental.jvm.internal.CoroutineIntrinsics;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.experimental.CancellableContinuation;
import kotlinx.coroutines.experimental.CancellableContinuationImpl;
import kotlinx.coroutines.experimental.Job;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a+\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001d\u001a\u0014\u0010\u001e\u001a\u00020\u001f*\u00020\u00182\u0006\u0010 \u001a\u00020\u0010H\u0000\u001a'\u0010!\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u0017*\b\u0012\u0004\u0012\u0002H\u00170\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00170$H\u0082\b\u0082\u0002\u0004\n\u0002\b\t\u00a8\u0006%"}, d2={"getRestApiMethodNameByRoomType", "", "roomType", "Lchat/rocket/common/model/BaseRoom$RoomType;", "method", "processCallbackError", "Lchat/rocket/common/RocketChatException;", "moshi", "Lcom/squareup/moshi/Moshi;", "response", "Lokhttp3/Response;", "logger", "Lchat/rocket/common/util/Logger;", "requestUrl", "Lokhttp3/HttpUrl$Builder;", "baseUrl", "Lokhttp3/HttpUrl;", "cancel", "", "Lokhttp3/OkHttpClient;", "tag", "", "handleRestCall", "T", "Lchat/rocket/core/RocketChatClient;", "request", "Lokhttp3/Request;", "type", "Ljava/lang/reflect/Type;", "(Lchat/rocket/core/RocketChatClient;Lokhttp3/Request;Ljava/lang/reflect/Type;Lkotlin/coroutines/experimental/Continuation;)Ljava/lang/Object;", "requestBuilder", "Lokhttp3/Request$Builder;", "httpUrl", "tryToResume", "Lkotlinx/coroutines/experimental/CancellableContinuation;", "getter", "Lkotlin/Function0;", "core"})
public final class RestClientKt {
    @NotNull
    public static final String getRestApiMethodNameByRoomType(@NotNull BaseRoom.RoomType roomType, @NotNull String method) {
        Intrinsics.checkParameterIsNotNull((Object)roomType, (String)"roomType");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        switch (RestClientKt$WhenMappings.$EnumSwitchMapping$0[roomType.ordinal()]) {
            case 1: {
                return "channels." + method;
            }
            case 2: {
                return "groups." + method;
            }
        }
        return "dm." + method;
    }

    @NotNull
    public static final HttpUrl.Builder requestUrl(@NotNull HttpUrl baseUrl, @NotNull String method) {
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        HttpUrl.Builder builder = baseUrl.newBuilder().addPathSegment("api").addPathSegment("v1").addPathSegment(method);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"baseUrl.newBuilder()\n   \u2026  .addPathSegment(method)");
        return builder;
    }

    @NotNull
    public static final Request.Builder requestBuilder(@NotNull RocketChatClient $receiver, @NotNull HttpUrl httpUrl) {
        Token token;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)httpUrl, (String)"httpUrl");
        Request.Builder builder = new Request.Builder().url(httpUrl);
        Token token2 = token = $receiver.getTokenRepository().get();
        if (token2 != null) {
            Token token3;
            Token it = token3 = token2;
            builder.addHeader("X-Auth-Token", token.getAuthToken()).addHeader("X-User-Id", token.getUserId());
        }
        Request.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
        return builder2;
    }

    @Nullable
    public static final <T> Object handleRestCall(@NotNull RocketChatClient $receiver, @NotNull Request request, @NotNull Type type, @NotNull Continuation<? super T> continuation) {
        boolean holdCancellability$iv = false;
        Continuation cont$iv = CoroutineIntrinsics.normalizeContinuation(continuation);
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(cont$iv, 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation2 = (CancellableContinuation)cancellable$iv;
        Callback callback = new Callback(continuation2, $receiver, type, request){
            final /* synthetic */ CancellableContinuation $continuation;
            final /* synthetic */ RocketChatClient receiver$0$inlined;
            final /* synthetic */ Type $type$inlined;
            final /* synthetic */ Request $request$inlined;
            {
                this.$continuation = $captured_local_variable$1;
                this.receiver$0$inlined = rocketChatClient;
                this.$type$inlined = type;
                this.$request$inlined = request;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                CancellableContinuation $receiver$iv = this.$continuation;
                if ($receiver$iv.isActive()) {
                    try {
                        CancellableContinuation cancellableContinuation = $receiver$iv;
                        throw (Throwable)new RocketChatNetworkErrorException("network error", (Throwable)e);
                    }
                    catch (Throwable exception$iv) {
                        $receiver$iv.resumeWithException(exception$iv);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) {
                block21: {
                    CancellableContinuation $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    if (!response.isSuccessful() && ($receiver$iv = this.$continuation).isActive()) {
                        try {
                            CancellableContinuation cancellableContinuation = $receiver$iv;
                            throw (Throwable)RestClientKt.processCallbackError(this.receiver$0$inlined.getMoshi$core(), response, this.receiver$0$inlined.getLogger());
                        }
                        catch (Throwable exception$iv) {
                            $receiver$iv.resumeWithException(exception$iv);
                        }
                    }
                    try {
                        JsonAdapter jsonAdapter = this.receiver$0$inlined.getMoshi$core().adapter(this.$type$inlined);
                        if (jsonAdapter == null) {
                            Intrinsics.throwNpe();
                        }
                        JsonAdapter adapter = jsonAdapter;
                        ResponseBody responseBody = response.body();
                        if (responseBody != null && (responseBody = responseBody.source()) != null) {
                            Unit unit;
                            ResponseBody responseBody2;
                            ResponseBody source = responseBody2 = responseBody;
                            Object object = adapter.fromJson((BufferedSource)source);
                            if (object != null) {
                                Object $i$f$tryToResume;
                                Object value = $i$f$tryToResume = object;
                                this.$continuation.resume(value);
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            CommonExtensionsKt.ifNull((Object)unit, (Function0)((Function0)new Function0<Unit>(this, adapter){
                                final /* synthetic */ handleRestCall$$inlined$suspendCancellableCoroutine$lambda$1 this$0;
                                final /* synthetic */ JsonAdapter $adapter$inlined;
                                {
                                    this.this$0 = var1_1;
                                    this.$adapter$inlined = jsonAdapter;
                                    super(0);
                                }

                                public final void invoke() {
                                    CancellableContinuation $receiver$iv = this.this$0.$continuation;
                                    if ($receiver$iv.isActive()) {
                                        try {
                                            CancellableContinuation cancellableContinuation = $receiver$iv;
                                            throw (Throwable)new RocketChatInvalidResponseException("Error parsing JSON message", null, 2, null);
                                        }
                                        catch (Throwable exception$iv) {
                                            $receiver$iv.resumeWithException(exception$iv);
                                        }
                                    }
                                }
                            }));
                        }
                    }
                    catch (Exception ex) {
                        Exception exception = ex;
                        if (exception instanceof JsonDataException || exception instanceof IllegalArgumentException || exception instanceof IOException) {
                            CancellableContinuation $receiver$iv2 = this.$continuation;
                            if (!$receiver$iv2.isActive()) {
                                break block21;
                            }
                            try {
                                CancellableContinuation cancellableContinuation = $receiver$iv2;
                                String string = ex.getMessage();
                                if (string == null) {
                                    Intrinsics.throwNpe();
                                }
                                throw (Throwable)new RocketChatInvalidResponseException(string, (Throwable)ex);
                            }
                            catch (Throwable exception$iv) {
                                $receiver$iv2.resumeWithException(exception$iv);
                                break block21;
                            }
                        }
                        CancellableContinuation $receiver$iv3 = this.$continuation;
                        if (!$receiver$iv3.isActive()) {
                            break block21;
                        }
                        try {
                            CancellableContinuation cancellableContinuation = $receiver$iv3;
                            throw (Throwable)ex;
                        }
                        catch (Throwable exception$iv) {
                            $receiver$iv3.resumeWithException(exception$iv);
                        }
                    }
                    finally {
                        ResponseBody responseBody = response.body();
                        if (responseBody != null) {
                            responseBody.close();
                        }
                    }
                }
            }
        };
        $receiver.getHttpClient().newCall(request).enqueue(callback);
        Job.DefaultImpls.invokeOnCompletion$default((Job)continuation2, (boolean)false, (Function1)((Function1)new Function1<Throwable, Unit>(continuation2, $receiver, type, request){
            final /* synthetic */ CancellableContinuation $continuation;
            final /* synthetic */ RocketChatClient receiver$0$inlined;
            final /* synthetic */ Type $type$inlined;
            final /* synthetic */ Request $request$inlined;
            {
                this.$continuation = cancellableContinuation;
                this.receiver$0$inlined = rocketChatClient;
                this.$type$inlined = type;
                this.$request$inlined = request;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                if (this.$continuation.isCancelled()) {
                    OkHttpClient okHttpClient = this.receiver$0$inlined.getHttpClient();
                    Object object = this.$request$inlined.tag();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"request.tag()");
                    RestClientKt.access$cancel(okHttpClient, object);
                }
            }
        }), (int)1, null);
        return cancellable$iv.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final RocketChatException processCallbackError(@NotNull Moshi moshi, @NotNull Response response, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)moshi, (String)"moshi");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        try {
            block19: {
                block18: {
                    v0 /* !! */  = response.body();
                    if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .string()) == null) {
                        v0 /* !! */  = "missing body";
                    }
                    body /* !! */  = v0 /* !! */ ;
                    logger.debug((Function0)new Function0<String>((String)body /* !! */ ){
                        final /* synthetic */ String $body;

                        @NotNull
                        public final String invoke() {
                            return "Error body: " + this.$body;
                        }
                        {
                            this.$body = string;
                            super(0);
                        }
                    });
                    if (response.code() != 401) break block18;
                    v1 = adapter = moshi.adapter(AuthenticationErrorMessage.class);
                    message = v1 != null ? (AuthenticationErrorMessage)v1.fromJson((String)body /* !! */ ) : null;
                    v2 = message;
                    if (v2 == null || (v2 = v2.getError()) == null) ** GOTO lbl-1000
                    var7_9 = v2;
                    var8_10 = "totp-required";
                    v3 = var7_9;
                    if (v3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    if (v3.contentEquals(var8_10)) {
                        v4 = (RocketChatException)new RocketChatTwoFactorException(message.getMessage());
                    } else lbl-1000:
                    // 2 sources

                    {
                        if ((v5 /* !! */  = message) == null || (v5 /* !! */  = v5 /* !! */ .getMessage()) == null) {
                            v5 /* !! */  = "Authentication problem";
                        }
                        v4 = (RocketChatException)new RocketChatAuthException((String)v5 /* !! */ );
                    }
                    break block19;
                }
                v6 = adapter = moshi.adapter(ErrorMessage.class);
                message = v6 != null ? (ErrorMessage)v6.fromJson((String)body /* !! */ ) : null;
                v7 /* !! */  = message;
                if (v7 /* !! */  == null || (v7 /* !! */  = v7 /* !! */ .getErrorType()) == null) {
                    v7 /* !! */  = String.valueOf(response.code());
                }
                if ((v8 /* !! */  = message) == null || (v8 /* !! */  = v8 /* !! */ .getError()) == null) {
                    v8 /* !! */  = "unknown error";
                }
                v4 = (RocketChatException)new RocketChatApiException((String)v7 /* !! */ , (String)v8 /* !! */ , null, 4, null);
            }
            exception = v4;
        }
        catch (IOException e) {
            v9 = String.valueOf(response.code());
            v10 = e.getMessage();
            if (v10 == null) {
                Intrinsics.throwNpe();
            }
            exception = (RocketChatException)new RocketChatApiException(v9, v10, (Throwable)e);
        }
        catch (NullPointerException e) {
            v11 = String.valueOf(response.code());
            v12 = e.getMessage();
            if (v12 == null) {
                Intrinsics.throwNpe();
            }
            exception = (RocketChatException)new RocketChatApiException(v11, v12, (Throwable)e);
        }
        finally {
            v13 = response.body();
            if (v13 != null) {
                v13.close();
            }
        }
        return exception;
    }

    private static final <T> void tryToResume(@NotNull CancellableContinuation<? super T> $receiver, Function0<? extends T> getter) {
        if (!$receiver.isActive()) {
            return;
        }
        try {
            $receiver.resume(getter.invoke());
        }
        catch (Throwable exception) {
            $receiver.resumeWithException(exception);
        }
    }

    private static final void cancel(@NotNull OkHttpClient $receiver, Object tag) {
        Object it;
        Call it2;
        Object element$iv$iv;
        Iterable $receiver$iv$iv;
        List list = $receiver.dispatcher().queuedCalls();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"dispatcher().queuedCalls()");
        Iterable $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it2 = (Call)element$iv$iv;
            if (!Intrinsics.areEqual((Object)tag, (Object)it2.request().tag())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (Call)element$iv;
            it.cancel();
        }
        List list2 = $receiver.dispatcher().runningCalls();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"dispatcher().runningCalls()");
        $receiver$iv = list2;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        it = $receiver$iv$iv.iterator();
        while (it.hasNext()) {
            element$iv$iv = it.next();
            it2 = (Call)element$iv$iv;
            if (!Intrinsics.areEqual((Object)tag, (Object)it2.request().tag())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            it = (Call)element$iv;
            it.cancel();
        }
    }

    public static final /* synthetic */ void access$tryToResume(@NotNull CancellableContinuation $receiver, @NotNull Function0 getter) {
        RestClientKt.tryToResume($receiver, getter);
    }

    public static final /* synthetic */ void access$cancel(@NotNull OkHttpClient $receiver, @NotNull Object tag) {
        RestClientKt.cancel($receiver, tag);
    }
}

