/*
 * Decompiled with CFR 0.152.
 */
package chat.rocket.common.util;

import chat.rocket.common.util.ISO8601Converter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0017\u00a8\u0006\t"}, d2={"Lchat/rocket/common/util/CalendarISO8601Converter;", "Lchat/rocket/common/util/ISO8601Converter;", "()V", "fromTimestamp", "", "timestamp", "", "toTimestamp", "date", "common"})
public final class CalendarISO8601Converter
implements ISO8601Converter {
    @Override
    @NotNull
    public String fromTimestamp(long timestamp) {
        Calendar calendar;
        TimeZone tz = TimeZone.getTimeZone("UTC");
        Calendar calendar2 = calendar = Calendar.getInstance(tz);
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"calendar");
        calendar2.setTimeInMillis(timestamp);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(tz);
        String string = df.format(calendar.getTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"df.format(calendar.time)");
        return string;
    }

    @Override
    public long toTimestamp(@NotNull String date) throws ParseException {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(tz);
        Date date2 = df.parse(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)date2, (String)"df.parse(date)");
        return date2.getTime();
    }
}

