package chat.rocket.android.renderer;

import android.content.Context;
import android.graphics.Color;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.widget.ImageView;
import android.widget.TextView;

import chat.rocket.android.R;
import chat.rocket.android.helper.Avatar;
import chat.rocket.android.helper.TextUtils;
import chat.rocket.android.model.ddp.User;

/**
 * Renderer for User model.
 */
public class UserRenderer extends AbstractRenderer<User> {

  public UserRenderer(Context context, User user) {
    super(context, user);
  }

  /**
   * show Avatar image
   */
  public UserRenderer avatarInto(ImageView imageView, String hostname) {
    if (!shouldHandle(imageView)) {
      return this;
    }

    if (!TextUtils.isEmpty(object.getUsername())) {
      new Avatar(hostname, object.getUsername()).into(imageView);
    }
    return this;
  }

  /**
   * show Username in textView
   */
  public UserRenderer usernameInto(TextView textView) {
    if (!shouldHandle(textView)) {
      return this;
    }

    final SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
    final ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(Color.BLACK);

    spannableStringBuilder.append(object.getUsername());
    spannableStringBuilder.setSpan(foregroundColorSpan, 0, object.getUsername().length(),
        Spannable.SPAN_INCLUSIVE_INCLUSIVE);

    textView.setText(spannableStringBuilder);

    return this;
  }

  /**
   * show user's status color into imageView.
   */
  public UserRenderer statusColorInto(ImageView imageView) {
    if (!shouldHandle(imageView)) {
      return this;
    }

    String status = object.getStatus();
    if (User.STATUS_ONLINE.equals(status)) {
      imageView.setImageResource(R.drawable.userstatus_online);
    } else if (User.STATUS_AWAY.equals(status)) {
      imageView.setImageResource(R.drawable.userstatus_away);
    } else if (User.STATUS_BUSY.equals(status)) {
      imageView.setImageResource(R.drawable.userstatus_busy);
    } else if (User.STATUS_OFFLINE.equals(status)) {
      imageView.setImageResource(R.drawable.userstatus_offline);
    } else {
      // unknown status is rendered as "offline" status.
      imageView.setImageResource(R.drawable.userstatus_offline);
    }

    return this;
  }
}
