package chat.rocket.android.fragment.add_server;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.Snackbar;
import android.view.View;
import android.widget.TextView;

import chat.rocket.android.BuildConfig;
import chat.rocket.android.LaunchUtil;
import chat.rocket.android.R;
import chat.rocket.android.RocketChatCache;
import chat.rocket.android.fragment.AbstractFragment;
import chat.rocket.android.helper.TextUtils;
import chat.rocket.android.service.ConnectivityManager;

/**
 * Input server host.
 */
public class InputHostnameFragment extends AbstractFragment implements InputHostnameContract.View {

  private InputHostnameContract.Presenter presenter;

  public InputHostnameFragment() {
  }

  @Override
  public void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    final Context appContext = getContext().getApplicationContext();

    presenter = new InputHostnamePresenter(
        RocketChatCache.get(appContext),
        ConnectivityManager.getInstance(appContext));
  }

  @Override
  protected int getLayout() {
    return R.layout.fragment_input_hostname;
  }

  @Override
  protected void onSetupView() {
    setupVersionInfo();

    rootView.findViewById(R.id.btn_connect).setOnClickListener(view -> handleConnect());
  }

  private void setupVersionInfo() {
    TextView versionInfoView = (TextView) rootView.findViewById(R.id.version_info);
    versionInfoView.setText(getString(R.string.version_info_text, BuildConfig.VERSION_NAME));
  }

  private void handleConnect() {
    presenter.connectTo(getHostname());
  }

  @Override
  public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
    super.onViewCreated(view, savedInstanceState);
    presenter.bindView(this);
  }

  @Override
  public void onDestroyView() {
    presenter.release();
    super.onDestroyView();
  }

  private String getHostname() {
    final TextView editor = (TextView) rootView.findViewById(R.id.editor_hostname);

    return TextUtils.or(TextUtils.or(editor.getText(), editor.getHint()), "").toString();
  }

  private void showError(String errString) {
    Snackbar.make(rootView, errString, Snackbar.LENGTH_LONG).show();
  }

  @Override
  public void showLoader() {
    rootView.findViewById(R.id.btn_connect).setEnabled(false);
  }

  @Override
  public void hideLoader() {
    rootView.findViewById(R.id.btn_connect).setEnabled(true);
  }

  @Override
  public void showInvalidServerError() {
    showError(getString(R.string.input_hostname_invalid_server_message));
  }

  @Override
  public void showConnectionError() {
    showError(getString(R.string.connection_error_try_later));
  }

  @Override
  public void showHome() {
    LaunchUtil.showMainActivity(getContext());
    getActivity().overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);
  }
}
