const http = require('http')
const fs = require('fs')
const path = require('path')
const process = require('process')
const Handler = require('./handler')
const { Client } = require('tdl')
const { TDLib } = require('tdl-tdlib-addon')
var clientNumber = process.argv[2];

module.exports = class TGClient {
	
	constructor(clientNumbers) {
		console.log("-= Constructing TGClient for NUMBER Inside: ", clientNumber);

		this.clientNumber = clientNumber;
		this.TGID = 0;
		this.prefix = '_tg';
		this.logStream = fs.createWriteStream(path.join(__dirname, 'logs/handler_'+this.clientNumber+'.log'), {flags: 'a'});
		this.tgc = new Client(new TDLib(path.join(__dirname, 'td/build/libtdjson.so')), {
			apiId: 234569,
			apiHash: 'ee77bf549e61d3de158916126c8ef7dd',
			tdlibParameters: {
				application_version: '1.0',
				device_model: 'TgClient',
				system_version: 'TgOS',
			}
		})
	}

	// getAuth() {
		// var tgAuth = tgclient.invoke({
		  // _: 'getAuthorizationState',
		  // chat_id: 124987160,
		// })
	// }
	start() {
		const self = this
		const clientNumber = this.clientNumber
		const tgclient = this.tgc
		
		const tgHandler = new Handler(clientNumber,tgclient);
		tgclient.on('error', console.error)
		tgclient.on('update', (...args) => tgHandler.listen(...args));
		
		tgclient.connect().then(function(){
			console.log("--= CONNECTED! Begin loggin in...")
			
			tgclient.login(() => ({
				getPhoneNumber: getClientPhoneNumber,
				getAuthCode: getClientAuthCode,
				getPassword: getClientPassword,
				// getName: () => Promise.resolve({ firstName: 'John', lastName: 'Doe' })
			}))
			.then(function(){
				console.log("--= ["+clientNumber+"] LOGGED IN!")
			});
		})
	}
	
	stop() {
		const self = this
		const clientNumber = this.clientNumber
		this.tgc.close()
	}
}



function getClientPhoneNumber(r) {
	console.log("- getting Phone NUMBER: ", clientNumber, r);
	return clientNumber;
}

function getClientAuthCode(r) {
	console.log("- getting AuthCode: ", r);
	return false;
}
function getClientPassword(passwordHint, r) {
	console.log("- getting ClientPassword: ", passwordHint, r);
	return false;
}

