const http = require('http')
const net = require('net')
const fs = require('fs')
const path = require('path')
const process = require('process')
const Handler = require('./handler')
const { Client } = require('tdl')
const { TDLib } = require('tdl-tdlib-addon')
const prefix = '_tg';

console.log("--======== TG Client Process ARGV:",  process.argv )

var clientNumber = process.argv[2];
var TGID = 0;
var clienDirectory = path.join(__dirname, 'clients/'+clientNumber)
var SOCKETFILE = path.join(clienDirectory, 'tgclient.sock')
var SHUTDOWN = false;
var tgServer;
connections = {};

if (!fs.existsSync(clienDirectory)){
    fs.mkdirSync(clienDirectory, { recursive: true });
}

var logStream = fs.createWriteStream(path.join(__dirname, 'logs/handler_'+clientNumber+'.log'), {flags: 'a'});
var tgclient = new Client(new TDLib(path.join(__dirname, 'td/build/libtdjson.so')), {
	apiId: 234569,
	apiHash: 'ee77bf549e61d3de158916126c8ef7dd',
	tdlibParameters: {
		application_version: '1.0',
		device_model: 'TgClient',
		system_version: 'TgOS',
	}
})
	
const tgHandler = new Handler(clientNumber,tgclient);

console.log(" ")
console.log("--======== TG Client ["+clientNumber+"] INITED!",)
tgHandler.ll(" ")
tgHandler.ll("--======== TG Client ["+clientNumber+"] INITED!")

tgHandler.ll(" ")
tgHandler.ll("--======== TG clienDirectory ["+clienDirectory+"]")
tgHandler.ll("--======== TG SOCKETFILE  ["+SOCKETFILE+"]")

function processIncom(msg){
	console.log("--===== INCOM MSG: "+msg);
	// msg = msg.toString(); 
	return '';
}


function startClient() {
	tgHandler.ll(" ")
	tgHandler.ll("--======== TG Client CMD: [startClient]-------")
}
// function startClient() {
	
	// tgclient.on('error', console.error)
	// tgclient.on('update', (...args) => tgHandler.listen(...args));
	
	// tgclient.connect().then(function(){
		// console.log("--= CONNECTEDS! Begin loggin in...")
		
		// tgclient.login(() => ({
			// getPhoneNumber: getClientPhoneNumber,
			// getAuthCode: getClientAuthCode,
			// getPassword: getClientPassword,
			// // getName: () => Promise.resolve({ firstName: 'John', lastName: 'Doe' })
		// }))
		// .then(function(){
			// console.log("--= ["+clientNumber+"] LOGGEDS IN!")
		// });
	// })
// }

// function stop() {
	// tgclient.close()
// }

// // getAuth() {
	// // var tgAuth = tgclient.invoke({
	  // // _: 'getAuthorizationState',
	  // // chat_id: 124987160,
	// // })
// // }



// function getClientPhoneNumber(r) {
	// console.log("- getting Phone NUMBER: ", clientNumber, r);
	// return clientNumber;
// }

// function getClientAuthCode(r) {
	// console.log("- getting AuthCode: ", r);
	// return false;
// }
// function getClientPassword(passwordHint, r) {
	// console.log("- getting ClientPassword: ", passwordHint, r);
	// return false;
// }

// console.log("--= Client Process for ["+clientNumber+"] INITed!")
// var myNumber = 0;

// const tgServer = http.createServer((req, res) => {
	// // const path = url.parse(req.url).path.split('/');
	// // var allMethods = ['start','stop','restart','state'];

	// myNumber = myNumber+1;
	// console.log(' ')
	// console.log(' ')
	// console.log('---=======- [ '+clientNumber+' ] ('+myNumber+') ---------')
	// console.log('This is the REQ:' + req)
	// console.log('This is the RES:' + res)
// });

// tgServer.on('error', (e) => {
  // if (e.code === 'EADDRINUSE') {
    // console.log('Address in use, retrying...', tgServer.listening);
    // setTimeout(() => {
		// if(tgServer.listening){
			// tgServer.close();
			// tgServerToListen();
		// }
		// else {
			// fs.unlink(clienSocketFile, function(err) {
				// if (err) {
					// throw err
				// } else {
					// console.log("Successfully deleted the socket file:",clienSocketFile)
					// tgServerToListen();
				// }
			// })
		// }
		
    // }, 1000);
  // }
// });



function tgServerToListen(){
    // check for failed cleanup
    console.log('--=== BEGIN to listening SOCKET...');
    fs.stat(SOCKETFILE, function (err, stats) {
        if (err) {
            // start server
            console.log('No leftover socket found.');
            tgServer = createServer(SOCKETFILE); return;
        }
        // remove file then start server
        console.log('Removing leftover socket.')
        fs.unlink(SOCKETFILE, function(err){
            if(err){
                // This should never happen.
                console.error(err); process.exit(0);
            }
            tgServer = createServer(SOCKETFILE); return;
        });  
    });

    // close all connections when the user does CTRL-C
    function cleanup(){
        if(!SHUTDOWN){ SHUTDOWN = true;
            console.log('\n',"Terminating.",'\n');
            if(Object.keys(connections).length){
                let clients = Object.keys(connections);
                while(clients.length){
                    let client = clients.pop();
                    connections[client].write('__disconnect');
                    connections[client].end(); 
                }
            }
            tgServer.close();
            process.exit(0);
        }
    }
	
    process.on('SIGINT', cleanup);

}

function createServer(socket){
	
    console.log('Creating server on socket: '+socket);
	
    var server = net.createServer(function(stream) {
        console.log('Connection acknowledged: '+socket);

        // Store all connections so we can terminate them if the server closes.
        // An object is better than an array for these.
        var self = Date.now();
        connections[self] = (stream);
        stream.on('end', function() {
            console.log('Client disconnected: '+socket);
            delete connections[self];
        });

        // Messages are buffers. use toString
        stream.on('data', function(msg) {
			var resultMsg = processIncom(msg);
			console.log("--===== INCOM RESULT: "+resultMsg);
			stream.write(resultMsg);
            // msg = msg.toString(); console.log("--===== INCOM MSG: "+msg);
            // if(msg === '__snootbooped'){
                // console.log("Client's snoot confirmed booped: "+socket);
                // return;
            // }

            // console.log('Client:', msg);

            // if(msg === 'foo'){
                // stream.write('bar');
            // }

            // if(msg === 'baz'){
                // stream.write('qux');
            // }

            // if(msg === 'here come dat boi'){
                // stream.write('Kill yourself.');
            // }

        });
    })
    .listen(socket)
    .on('connection', function(socket){
        console.log('Client connected.');
        console.log('Sending boop.');
        socket.write('__boop');
        //console.log(Object.keys(socket));
    })
    ;
    return server;
}

// function tgServerToListen(){
	// console.log(`--===== BEGIN TgServer listening: ${clienSocketFile}`)
	
	// tgServer.listen(clienSocketFile, 50, () => {
		// console.log(`--===== TgServer listens: ${clienSocketFile}`)
		// startClient();
	// });
// }

tgServerToListen();

process.on('message', function(packet) {
	
	console.log("- PM2 ON_MESSAGE: ", packet)
	
	if(typeof packet.data == 'object'){
		
		if(typeof packet.data.cmd != 'undefined' && typeof tgHandler[packet.data.cmd] == 'function'){
			var myFunc = tgHandler[packet.data.cmd].bind(tgHandler);
				myFunc(packet.data);
		}
		
	}
	
	process.send({
		type : 'process:msg',
		data : {
			success : true
		}
	});
});