const http = require('http')
const process = require('process')
// const tgclient = require('./tgclient')
// const logger = require('./logger')
const Handler = require('./handler')
const { Client } = require('tdl')
const { TDLib } = require('tdl-tdlib-addon')
var path = require('path'); 
var allClients = {};
var clientNumber = process.argv[2];

allClients[clientNumber] = {
	number: clientNumber
};

function getClientPhoneNumber(r) {
	console.log("- getting Phone NUMBER: ", clientNumber, r);
	return clientNumber;
}

function getClientAuthCode(r) {
	console.log("- getting AuthCode: ", r);
	return false;
}
function getClientPassword(passwordHint, r) {
	console.log("- getting ClientPassword: ", passwordHint, r);
	return false;
}

async function startTgclient() {
	console.log("-= Starting TGClient for NUMBER Inside: ", clientNumber);
	const tgclient = new Client(new TDLib(path.join(__dirname, 'td/build/libtdjson.so')), {
		apiId: 234569,
		apiHash: 'ee77bf549e61d3de158916126c8ef7dd',
		tdlibParameters: {
			application_version: '1.0',
			device_model: 'TgClient',
			system_version: 'TgOS',
		}
	})

	const tgHandler = new Handler(clientNumber,tgclient);

	tgclient.on('error', console.error)
	// tgclient.on('update', tgHandler.listen);
	tgclient.on('update', (...args) => tgHandler.listen(...args));
	
	tgclient.connect().then(function(){
		console.log("--= CONNECTED! Begin loggin in...")
		
		tgclient.login(() => ({
			getPhoneNumber: getClientPhoneNumber,
			getAuthCode: getClientAuthCode,
			getPassword: getClientPassword,
			// getName: () => Promise.resolve({ firstName: 'John', lastName: 'Doe' })
		}))
		.then(function(){
			console.log("--= LOGGED IN!")
		});
	})

	// await tgclient.connectAndLogin()

	// var meInfo = await tgclient.invoke({ _: 'getMe' }))
	// console.log("--= ME: ",meInfo)
}

console.log("-= Begin Client for NUMBER: ", clientNumber);
startTgclient().catch(console.error)



var myNumber = 1;

const host = '192.168.130.10'
const port = 51000

function notFound(res) {
  res.statusCode = 404
  res.setHeader('Content-Type', 'text/plain')
  res.end('Not found\n')
}

function parseUrl(url)
{
    var split = /^.*\/(getAuth|getMe|getUser|getUserFullInfo)_([^?]*)\??(.*)$/gi.exec(url);
    var final_params = {};
    split[3].split('&').forEach(function(pair){
       var ps = pair.split('=');
       final_params[ps[0]] = ps[1];
    });
    return {
        name: split[1], 
        value: split[2], 
        params: final_params
    };
}

const server = http.createServer((req, res) => {
	//getAuthorizationState
	myNumber = myNumber+1;
	console.log(' ')
	console.log(' ')
	console.log('---=======- [ '+myNumber+' ] ---------')
	console.log('This is the METHOD:' + req.method)
	console.log('This is the URL:' + req.url)
	console.log('This is the REQUEST Hdrs:')
	
	console.log(req.headers)
	
	switch (req.method) { 
		case 'GET': {
			switch (req.url) {
				case '/home': {
					res.statusCode = 200
					res.setHeader('Content-Type', 'text/plain')
					res.end('Home page\n')
					break
				}
				case '/about': {
					res.statusCode = 200
					res.setHeader('Content-Type', 'text/plain')
					res.end('About page\n')
					break
				}
				case '/test': {
					
					const chats = tgclient.invoke({
					  _: 'sendMessage',
					  chat_id: 124987160,
					  input_message_content: {
						_: 'inputMessageText',
						text: {
						  _: 'formattedText',
						  text: '👻 Test 123'
						}
					  }
					})
					
	
					res.statusCode = 200
					res.setHeader('Content-Type', 'text/plain')
					res.end('About page\n')
					break
				}
				
				case '/getAuth': {
					
					var tgAuth = tgclient.invoke({
					  _: 'getAuthorizationState',
					  chat_id: 124987160,
					})
					
					res.statusCode = 200
					res.setHeader('Content-Type', 'text/plain')
					res.end(tgAuth)
					break
				}
				case '/': {
					res.statusCode = 200
					res.setHeader('Content-Type', 'text/plain')
					res.end('Hello main\n')
					break
				}
				default: {
					notFound(res)
					break
				}
			}
			break
		}
		case 'POST': {
			const reuqest = req.body;
			const headers = req.headers;
			console.log('-= REQUEST:', reuqest)
			console.log('-= HEADERS:', headers)
	
			switch (req.url) {
				case '/api/admin': {
					res.statusCode = 200
					res.setHeader('Content-Type', 'text/plain')
					res.end('Create admin request\n')
					break
				}
				case '/api/user': {
					res.statusCode = 200
					res.setHeader('Content-Type', 'text/plain')
					res.end('Create user request\n')
					break
				}
				case '/sendMessage': {
					const sentMessage = tgclient.invoke({
						_: 'sendMessage',
						chat_id: 124987160,
						input_message_content: {
							_: 'inputMessageText',
							text: {
								_: 'formattedText',
								text: '👻 Test 123'
							}
						}
					})
					
					
					console.log('-=-=-= SENT MESSAGE: ')
					console.log(sentMessage)
					
					res.statusCode = 200
					res.setHeader('Content-Type', 'text/plain')
					res.end('Sent')
					break
				}
				default: {
					notFound(res)
					break
				}
			}

			break
		}
		default: {
		  notFound(res)
		  break
		}
	}
})

server.listen(port, host, () => {
  console.log(`Server listens http://${host}:${port}`)
})
// server.listen(port, host, () => {
  // console.log(`Server listens http://${host}:${port}`)
// })


