const http = require('http')
const url = require('url')
const process = require('process')
// const TGClient = require('./tgc')
var path = require('path') 
const pm2 = require('pm2')
var allClients = {};
var pm2Connected = false;
var myNumber = 1;
const host = '192.168.130.10'
const port = 51000

function parseUrl(url)
{
    var split = /^.*\/(getAuth|getMe|getUser|getUserFullInfo)_([^?]*)\??(.*)$/gi.exec(url);
    var final_params = {};
    split[3].split('&').forEach(function(pair){
       var ps = pair.split('=');
       final_params[ps[0]] = ps[1];
    });
    return {
        name: split[1], 
        value: split[2], 
        params: final_params
    };
}

function list(cbk){
	
	if(pm2Connected){
		
		pm2.list((err, list) => {
			
			var processes = [];
			
			if(typeof list != 'undefined' && list){
				
				var pnn = 1;
			
				list.forEach(function(app){
					console.log("-= PM2 Listing processes EACH: ", app);
					var currProcc = {
						pm_id: app.pm_id,
						pm_name: app.name,
						pm_monit: app.monit,
						pm_status: (app.pm2_env && app.pm2_env.status && app.pm2_env.status=="online")
					};
					
					if(app.name.substring(0,4)=="tgc_"){
						var currClNumber = app.name.substring(4);
						if(!allClients[currClNumber]){
							allClients[currClNumber] = {
								name: app.name,
								pm_id: app.pm_id,
								status: currProcc.pm_status
							}
						}
						else {
							allClients[currClNumber]['status'] = currProcc.pm_status
						}
					}
					
					processes.push(currProcc);
					
					if(pnn==list.length){
						if(typeof cbk != 'undefined'){
							cbk(processes);
						}
					}
					else {
						pnn = pnn+1;
					}
				})
			}
		});
	}
}

function state(clientNumber){
	console.log("-= Starting TGClient for allClients: ", allClients);
	console.log("-= Starting TGClient for allClients NUM: ", allClients[clientNumber]);
	return { result: (allClients[clientNumber] && allClients[clientNumber]['status']) ? true : false };
}

function start(clientNumber){
	console.log("-= Starting TGClient for NUMBER: ", clientNumber);
	allClients[clientNumber] = {}
	
	if(pm2Connected){
		list(function(){
			if(!allClients[clientNumber]['status']){
				pm2.start({
					script    : 'tgc.js',
					name      : 'tgc_'+clientNumber,
					args : clientNumber
				}, function(err, startedApp) {
					if (err) {
					  console.error(err)
					  return pm2.disconnect()
					}
					
					if(startedApp) {
						startedApp.forEach(function(app){
							if(app.name=='tgc_'+clientNumber){
								allClients[clientNumber]['name'] = app.name
								allClients[clientNumber]['pm_id'] = app.pm_id
							}
						})
					}
					console.log("-= Starting for startedApp: ", startedApp);
					
					senddata(clientNumber, {cmd:'startClient'})
				})
			}
		})
		
	}
	
	// const tclient = new TGClient(clientNumber);
	// tclient.start();
	// allClients[clientNumber]['tgclient'] = tclient;
	
	// console.log('---=======- CLIENT CNT [ '+Object.keys(allClients).length+' ] ---------')
	
	return {result:true};
}

function stop(clientNumber){
	console.log("--== STOPing COMMAND: ", pm2Connected, clientNumber, allClients);
	// allClients[clientNumber]['tgclient'].stop();
	
	if(pm2Connected){
		console.log("--== STOPing pm ID: ", allClients[clientNumber]);
		
		var pmIden = (allClients[clientNumber] && allClients[clientNumber]['pm_id']) ? allClients[clientNumber]['pm_id'] : 'tgc_'+clientNumber;
		
		pm2.stop(pmIden, 
		function(err, stopedApp) {
			if (err) {
			  console.error(err)
			  return pm2.disconnect()
			}
			
			console.log("-= Starting for stopedApp: ", stopedApp);
			
			if(typeof stopedApp.status != 'undefined' && stopedApp.status=='stopped'){
				allClients[clientNumber]['status'] = false;
			}
			else if(typeof stopedApp.pm2_env != 'undefined' && typeof stopedApp.pm2_env.status != 'undefined' && stopedApp.status=='stopped'){
				allClients[clientNumber]['pm_id'] = stopedApp.pm_id;
				allClients[clientNumber]['status'] = false;
			}
		})
	}
	return {result:true};
}


function restart(clientNumber){
	console.log("--== RESTARTing COMMAND: ", clientNumber);
	
	if(pm2Connected && allClients[clientNumber] && allClients[clientNumber]['pm_id']){
		pm2.restart(allClients[clientNumber]['pm_id'], {}, 
		function(err, restartedApp) {
			if (err) {
			  console.error(err)
			  return pm2.disconnect()
			}
			
			console.log("-= Starting for restartedApp: ", restartedApp);
		})
	}
	
	return {result:true};
}

function senddata(clientNumber, data){
	console.log("--== SENDing Data to: ", clientNumber, data);
	
	if(pm2Connected && allClients[clientNumber] && allClients[clientNumber]['pm_id']){
		pm2.sendDataToProcessId({
			// id of procces from "pm2 list" command or from pm2.list(errback) method
			id   : allClients[clientNumber]['pm_id'],
			// process:msg will be send as 'message' on target process
			type : 'process:msg',

			// Data to be sent
			data : data,

			topic: true
		}, function(err, res) {
			console.log("-= SendData ERROR: ", err, res);
		})
	}
}

var getString = (o) => {
    if (o !== null) {
        if (typeof o === 'string') {
            return o;
        } else {
            return JSON.stringify(o);
        }
    } else {
        return null;
    }
}

const server = http.createServer((req, res) => {
	//getAuthorizationState
	// let url=req.url.parse(req.originalUrl);
	// let page = url.parse(uri).path?url.parse(uri).path.match('^[^?]*')[0].split('/').slice(1)[0] : '';
	
	const path = url.parse(req.url).path.split('/');
	var allMethods = ['start','stop','restart','state','list'];
	
	
	myNumber = myNumber+1;
	console.log(' ')
	console.log(' ')
	console.log('---=======- [ '+myNumber+' ] ---------')
	console.log('This is the METHOD:' + req.method)
	// console.log('This is the URL:' + url)
	console.log('This is the path:', path)
	console.log('This is the REQUEST Hdrs:')
	console.log(req.headers)
	
	var param = (path[2] && path[2].length) ? path[2].replace(/\D/g, '') : false;
	
	console.log('This is the PARAM:', param)
	
	if(path[1] && path[1].length && allMethods.indexOf(path[1])!='-1'){

		console.log(' ')
		console.log(' --------======== COMMAND ['+path[1]+'] =======-----------')
		console.log("--== CLIENTS: ", allClients);
		console.log(' ')
		
		if(param){
			var result = eval(path[1])(param);
			console.log(' -= Cmd Params:', param)
		}
		else {
			var result = eval(path[1]);
		}
		
		console.log(' --------======== COMMAND RES:', result)
		
		if(result){
			var resStr = getString(result)
			console.log(' --------======== COMMAND RES TEXT:', resStr)
			res.statusCode = 200
			res.setHeader('Content-Type', 'application/json')
			res.end(resStr)
		}
	}
	else {
		res.statusCode = 404
		res.setHeader('Content-Type', 'text/plain')
		res.end('Command not found\n')
	}
})

server.listen(port, host, () => {
	
	console.log(`Server listens http://${host}:${port}`)
	
	pm2.connect(function(err) {
		if (err) {
			pm2Connected = false
			console.error(err)
			process.exit(2)
		}
		pm2Connected = true
		console.log('-= PM2 connected!')
		
		pm2.launchBus(function(err, pm2_bus) {
			console.log("-= PM2 incom LaunchBUS Started!",err)
			
			pm2_bus.on('process:msg', function(packet) {
				console.log("-= PM2 incom PACKET:",packet)
			})
		})
		
		list();
	});
})
// server.listen(port, host, () => {
  // console.log(`Server listens http://${host}:${port}`)
// })


