const fs = require('fs');
const path = require('path'); 

var getString = (o) => {
    if (o !== null) {
        if (typeof o === 'string') {
            return o;
        } else {
            return JSON.stringify(o);
        }
    } else {
        return null;
    }
}

module.exports = class Handler {
	
	constructor(clientNumber,tgclient) {
		this.clientNumber = clientNumber;
		this.TGID = 0;
		this.prefix = '_tg';
		this.tgc = tgclient;
		this.logStream = fs.createWriteStream(path.join(__dirname, 'logs/handler_'+this.clientNumber+'.log'), {flags: 'a'});
		// this.logStream = fs.createWriteStream('/var/www/tgc/logs/handler_'+this.clientNumber+'.log', {flags: 'a'});
	}

	listen(update) {
		
		
		
		if(update._ && typeof this[update._] == 'function'){
			var myFunc = this[update._].bind(this);
			myFunc(update);
		}
		else {
			this.ll("\n--== "+getString(update));
			return;
		}
	}
	
	updateOption (update){
		this.ll('__updateOption ['+this.TGID+'] :'+getString(update))
		// console.log();
		if(update.name && update.value.value && update.name=="my_id"){
			this.TGID = update.value.value;
		}
	}
	
	updateAuthorizationState (update){
		this.ll('__updateAuthorizationState ['+this.TGID+']['+this.clientNumber+'] :'+getString(update))
	}
	
	updateUserStatus(update){
		this.ll('__updateUserStatus ['+this.TGID+'] :'+getString(update))
		// console.log('-- updateUserStatus ['+this.TGID+'] :', update);
	}
	
	updateChatAction(update){
		this.ll('__updateChatAction ['+this.TGID+'] :'+getString(update))
		// console.log('-- updateChatAction ['+this.TGID+'] :', update);
	}
	
	ll(log){
		var logline = (typeof tog != "string") ? getString(log) : log;
		var time = Math.floor(Date.now() / 1000);
		this.logStream.write("\n--==["+time+"]"+logline);
	}
};